package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.util.LinkedList;
import java.util.Set;
import java.util.Collection;
import java.util.Iterator;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;

/**
 * Base class for all actions that work on a single currently selected object.
 */
public abstract class AbstractSingleObjectAction extends AbstractEditorAction {

    public AbstractSingleObjectAction(OIModelerModule oimodelerModule,String actionID) {
        super(oimodelerModule,actionID);
    }
    public void actionPerformed(ActionEvent e) {
        try {
            List events=new LinkedList();
            Entity focusedEntity=getFocusedEntity();
            Iterator iterator=getSelection().iterator();
            while (iterator.hasNext()) {
                Object selectedObject=iterator.next();
                if ((selectedObject instanceof Entity) && !focusedEntity.equals(selectedObject)) {
                    ChangeEvent changeEvent=getChangeEvent(focusedEntity,(Entity)selectedObject);
                    if (changeEvent!=null)
                        events.add(changeEvent);
                }
            }
            if (!events.isEmpty())
                getViewable().changeOIModel(events);
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        boolean enabled=commandsAreEnabled() && getOIModelerSelectionType()==getAlloverFocusedType() && getOIModelerSelection().size()==1;
        if (enabled) {
            try {
                enabled=false;
                Entity focusedEntity=getFocusedEntity();
                Collection selection=getSelection();
                if (!selection.isEmpty()) {
                    Set relatedSet=getRelatedSet(focusedEntity);
                    Iterator iterator=selection.iterator();
                    while (iterator.hasNext()) {
                        Object selectedObject=iterator.next();
                        if ((selectedObject instanceof Entity) && !focusedEntity.equals(selectedObject)) {
                            if (relatedSet==null || (willAddToSet() ? !relatedSet.contains(selectedObject) : relatedSet.contains(selectedObject))) {
                                ChangeEvent changeEvent=getChangeEvent(focusedEntity,(Entity)selectedObject);
                                if (changeEvent!=null) {
                                    enabled=true;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            catch (KAONException e) {
                enabled=false;
            }
        }
        setEnabled(enabled);
    }
    protected abstract ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException;
    protected abstract int getAlloverFocusedType();
    protected abstract Set getRelatedSet(Entity focusedEntity) throws KAONException;
    protected abstract boolean willAddToSet();
}
