package de.fzi.wim.oimodeler.actions;

import java.util.Map;
import java.util.Collection;
import java.util.Collections;

import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.actions.*;
import de.fzi.wim.guibase.appdriver.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Base class for all actions of the editor.
 */
public abstract class AbstractEditorAction extends AbstractSmartAction {
    /** The OI-modeler module. */
    protected OIModelerModule m_oimodelerModule;
    /** The overriding of the viewable. */
    protected OIModelerViewable m_oimodelerViewableOverride;
    /** The overriding of the selection. */
    protected Collection m_selectionOverride;

    public AbstractEditorAction(OIModelerModule oimodelerModule,String actionID) {
        super(actionID,oimodelerModule.getAppDriver().getLocalizationManager());
        m_oimodelerModule=oimodelerModule;
    }
    protected void updateAs(String pseudoActionID) {
        Map pseudoActionMap=m_oimodelerModule.getAppDriver().getLocalizationManager().getActionMap(pseudoActionID);
        pseudoActionMap.remove("actionID");
        setToActionMap(pseudoActionMap);
    }
    protected boolean commandsAreEnabled() {
        OIModelerViewable viewable=getViewable();
        return viewable!=null && viewable.commandsAreEnabled();
    }
    protected OIModelerViewable getViewable() {
        if (m_oimodelerViewableOverride!=null)
            return m_oimodelerViewableOverride;
        else {
            Viewable viewable=m_oimodelerModule.getAppDriver().getSelectedViewable();
            if (viewable instanceof OIModelerViewable)
                return (OIModelerViewable)viewable;
            else
                return null;
        }
    }
    protected Collection getSelection() {
        if (m_selectionOverride!=null)
            return m_selectionOverride;
        else {
            Collection selection=null;
            OIModelerViewable oimodelerViewable=getViewable();
            if (oimodelerViewable!=null)
                selection=oimodelerViewable.getOIModelerSelectionSourceManager().getActiveSelection();
            if (selection==null)
                selection=Collections.EMPTY_SET;
            return selection;
        }
    }
    protected int getSelectionType() {
        if (m_selectionOverride!=null)
            return OIModelerSelectionSourceManager.getSelectionType(m_selectionOverride);
        else {
            OIModelerViewable oimodelerViewable=getViewable();
            if (oimodelerViewable!=null)
                return oimodelerViewable.getOIModelerSelectionSourceManager().getActiveSelectionType();
            else
                return 0;
        }
    }
    protected Collection getOIModelerSelection() {
        Collection selection=null;
        OIModelerViewable oimodelerViewable=getViewable();
        if (oimodelerViewable!=null)
            selection=oimodelerViewable.getOIModelerSelectionModel().getSelectedEntities();
        if (selection==null)
            selection=Collections.EMPTY_SET;
        return selection;
    }
    protected int getOIModelerSelectionType() {
        OIModelerViewable oimodelerViewable=getViewable();
        if (oimodelerViewable!=null)
            return oimodelerViewable.getOIModelerSelectionModel().getSelectionType();
        else
            return 0;
    }
    protected Entity getFocusedEntity() {
        if (getOIModelerSelection().size()!=1)
            return null;
        else
            return (Entity)getOIModelerSelection().iterator().next();
    }
    protected Concept getFocusedConcept() {
        if (getOIModelerSelection().size()!=1 || getOIModelerSelectionType()!=OIModelerSelectionModel.CONTAINS_CONCEPTS)
            return null;
        else
            return (Concept)getOIModelerSelection().iterator().next();
    }
    protected Property getFocusedProperty() {
        if (getOIModelerSelection().size()!=1 || getOIModelerSelectionType()!=OIModelerSelectionModel.CONTAINS_PROPERTIES)
            return null;
        else
            return (Property)getOIModelerSelection().iterator().next();
    }
    protected Instance getSelectedInstance() {
        if (getOIModelerSelection().size()!=1 || getOIModelerSelectionType()!=OIModelerSelectionModel.CONTAINS_INSTANCES)
            return null;
        else
            return (Instance)getOIModelerSelection().iterator().next();
    }
    public void setOverride(OIModelerViewable oimodelerViewableOverride,Collection selectionOverride) {
        m_oimodelerViewableOverride=oimodelerViewableOverride;
        m_selectionOverride=selectionOverride;
    }
}
