package de.fzi.wim.oimodeler;

import java.util.Map;
import java.util.List;
import java.util.LinkedList;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.appdriver.*;
import de.fzi.wim.guibase.configuration.*;

import de.fzi.wim.oimodeler.actions.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Main module for the OI-modeler.
 */
public class OIModelerModule extends AbstractModule {
    /** The name of this module. */
    public static final String NAME="OIModelerModule";

    /** The array of language codes and their names. */
    protected String[][] m_languages;

    /**
     * Creates an instance of this class.
     */
    public OIModelerModule() {
    }
    /**
     * Returns the name of the localization resource that should be loaded for this module.
     *
     * @return                              the name of the localization resource
     */
    public String getLocalizationResourceName() {
        return "de/fzi/wim/oimodeler/res/oimodeler.xml";
    }
    /**
     * Sets the application driver of the module.
     *
     * @param appDriver                     application driver
     */
    public void setAppDriver(AppDriver appDriver) {
        super.setAppDriver(appDriver);
        loadLanguages(appDriver);
        addAction(new RemoveSelectedEntities(this));
        addAction(new NewConcept(this));
        addAction(new NewProperty(this));
        addAction(new NewInstance(this));
        addAction(new AddToClipboard(this));
        addAction(new RemoveFromClipboard(this));
        addAction(new AddToSubConcepts(this));
        addAction(new AddToSuperConcepts(this));
        addAction(new RemoveFromSubConcepts(this));
        addAction(new RemoveFromSuperConcepts(this));
        addAction(new AddToPropertiesFrom(this));
        addAction(new AddToPropertiesTo(this));
        addAction(new RemoveFromPropertiesFrom(this));
        addAction(new RemoveFromPropertiesTo(this));
        addAction(new AddToConceptInstances(this));
        addAction(new RemoveFromConceptInstances(this));
        addAction(new AddToSubProperties(this));
        addAction(new AddToSuperProperties(this));
        addAction(new RemoveFromSubProperties(this));
        addAction(new RemoveFromSuperProperties(this));
        addAction(new AddToPropertyDomain(this));
        addAction(new AddToPropertyRange(this));
        addAction(new RemoveFromPropertyDomain(this));
        addAction(new RemoveFromPropertyRange(this));
        addAction(new AddAttributeInstance(this));
        addAction(new AddRelationInstance(this));
        addAction(new MakeInverseProperties(this));
        addAction(new ClearInverseProperty(this));
        addAction(new OpenOIModel(this));
        addAction(new Import(this));
        addAction(new Export(this));
        addAction(new NewOIModel(this));
        addAction(new DuplicateOIModel(this));
        addAction(new CopyToNewOIModel(this));
        addAction(new CreateOIModelEvolutionLog(this));
        addAction(new DeleteOIModelEvolutionLog(this));
        addAction(new SaveOIModel(this));
        addAction(new RefreshOIModel(this));
        addAction(new DeleteOIModel(this));
        addAction(new ResolveReplicationInconsistency(this));
        addAction(new FocusSelection(this));
        addAction(new ShowSelectionOnly(this));
        addAction(new HideSelection(this));
        addAction(new CopySelectionURIs(this));
        addAction(new IncrementalSearchGraph(this));
        addAction(new SetUpDefaultEvolutionParameters(this));
        addAction(new SetOIModelOriginal(this));
        addAction(new OpenAndIncludeOIModel(this));
        addAction(new ViewGraph(this));
        addAction(new ViewInspector(this));
        addAction(new ViewClipboard(this));
        addAction(new ViewSystemObjects(this));
        addAction(new ShowEvolutionDetails(this));
        addAction(new ShowGraphBlackAndWhite(this));
        addAction(new ShowGraphForScreenCapture(this));
        addAction(new SetLanguage(this));
        addAction(new PinInspector(this));
        addAction(new ToggleInspectors(this));
        addAction(new PinInference(this));
        addAction(new ChangeInference(this));
        addAction(new EditDocumentation(this));
    }
    /**
     * Returns the name of the module.
     *
     * @return                              the name of this module
     */
    public String getModuleName() {
        return NAME;
    }
    /**
     * Called to restore the saved UI state of the viewable.
     *
     * @param configuration                 the configuration
     */
    public void restoreUIState(Configuration configuration) {
        String physicalURI=configuration.getString("physicalURI");
        String languageURI=configuration.getString("languageURI");
        Map parameters=configuration.getMap("connection");
        if (physicalURI!=null && parameters!=null) {
            KAONConnection kaonConnection=null;
            try {
                kaonConnection=KAONManager.getKAONConnection(parameters);
                OIModel oimodel=kaonConnection.openOIModelPhysical(physicalURI);
                OIModelerViewable newViewable=new OIModelerViewable(this,kaonConnection,oimodel);
                newViewable.setLanguageURI(languageURI);
                Configuration defaultEvolutionConfiguration=configuration.getSubConfiguration("defaultEvolutionParameters");
                SetUpDefaultEvolutionParametersDlg.loadEvolutionParameters(defaultEvolutionConfiguration,newViewable.getEvolutionParameters());
                m_appDriver.newViewableAncor(newViewable,configuration);
            }
            catch (KAONException ignored) {
                if (kaonConnection!=null)
                    try {
                        kaonConnection.close();
                    }
                    catch (KAONException ignored2) {
                    }
            }
        }
    }
    /**
     * Returns the array of language codes and their names.
     *
     * @return                              the array of language codes and their names
     */
    public String[][] getLanguages() {
        return m_languages;
    }
    /**
     * Loads the languages from the GUI configuration.
     *
     * @param appDriver                     the application driver
     */
    protected void loadLanguages(AppDriver appDriver) {
        List list=new LinkedList();
        NodeList oimodelersList=appDriver.getGUIConfiguration().getElementsByTagName("oimodeler");
        if (oimodelersList.getLength()>=1) {
            Node oimodeler=oimodelersList.item(0);
            NodeList languagesList=oimodeler.getChildNodes();
            for (int i=0;i<languagesList.getLength();i++) {
                Node languages=languagesList.item(i);
                if ("languages".equals(languages.getNodeName())) {
                    NodeList languageList=languages.getChildNodes();
                    for (int j=0;j<languageList.getLength();j++) {
                        Node language=languageList.item(j);
                        if ("language".equals(language.getNodeName()) && language.hasChildNodes()) {
                            String languageCode=language.getFirstChild().getNodeValue();
                            list.add(new String[] { languageCode,appDriver.getLocalizationManager().getPhrase("language."+languageCode) });
                        }
                    }
                    break;
                }
            }
        }
        m_languages=new String[list.size()][];
        list.toArray(m_languages);
    }
}
