package de.fzi.wim.kaonportal.tree;

/**
 * A node in the tree.
 */
public class TreeNode {
    /** The ID of the node. */
    protected String m_id;
    /** The expanded state of the tree node. */
    protected boolean m_expanded;
    /** The array of children. */
    protected TreeNode[] m_children;

    /**
     * Creates an instance of this class.
     *
     * @param id                            the ID of the node
     */
    public TreeNode(String id) {
        m_id=id;
    }
    /**
     * Returns the ID of the node.
     *
     * @return                              the ID of the node
     */
    public String getID() {
        return m_id;
    }
    /**
     * Returns <code>true</code> if this node is expanded.
     *
     * @return                              <code>true</code> if this node is expanded
     */
    public boolean getExpanded() {
        return m_expanded;
    }
    /**
     * Determines whether this node is expanded.
     *
     * @param expanded                      the expanded state of the node
     */
    public void setExpanded(boolean expanded) {
        m_expanded=expanded;
    }
    /**
     * Returns <code>true</code> if the children of this node have been loaded.
     *
     * @return                              <code>true</code> if children have been loaded
     */
    public boolean getChildrenLoaded() {
        return m_children!=null;
    }
    /**
     * Sets specified children into the node.
     *
     * @param children                      the children of the node (if <code>null</code> children are unloaded)
     */
    public void setNodeChildren(TreeNode[] children) {
        m_children=children;
        if (m_children==null)
            m_expanded=false;
    }
    /**
     * Returns the array of children of this node.
     *
     * @return                              the children of this node (<code>null</code> if children haven't been loaded)
     */
    public TreeNode[] getChildren() {
        return m_children;
    }
    /**
     * Returns the number of children of this node.
     *
     * @return                              the number of children of this node
     */
    public int getChildCount() {
        if (m_children==null)
            return 0;
        else
            return m_children.length;
    }
    /**
     * Returns <code>true</code> if this node is leaf.
     *
     * @return                              <code>true</code> if this node is leaf
     */
    public boolean isLeaf() {
        return getChildrenLoaded() && getChildCount()==0;
    }
}
