package de.fzi.wim.kaonportal.tags;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

import de.fzi.wim.kaonportal.multilingual.*;

/**
 * This tag class is used to print either a login form or the current user
 * depending on its attributes.
 *
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class UserLoginTag extends TagSupport {
    /** property declaration for tag attribute: forcelogin. */
    private boolean forcelogin;

    /** property declaration for tag attribute: requirepassword. */
    private boolean requirepassword;

    /** property declaration for tag attribute: requirelogin. */
    private boolean requirelogin;

    /** property declaration for tag attribute: requirelogout. */
    private boolean requirelogout;

    /** property declaration for tag attribute: textclass. */
    private String textclass;

    /** property declaration for tag attribute: width. */
    private String width;

    /** property declaration for tag attribute: tableexists. */
    private String tableexists;

    /**
     * Bean method to return the <code>forcelogin</code> parameter.
     *
     * @return String - returns the <code>forcelogin</code> parameter
     */
    public boolean getForcelogin() {
        return forcelogin;
    }

    /**
     * Bean method to set the <code>forcelogin</code> parameter.
     *
     * @param value new value of <code>forcelogin</code>
     */
    public void setForcelogin(boolean value) {
        forcelogin = value;
    }

    /**
     * Bean method to return the <code>requirepassword</code> parameter.
     *
     * @return String - returns the <code>requirepassword</code> parameter
     */
    public boolean getRequirepassword() {
        return requirepassword;
    }

    /**
     * Bean method to set the <code>requirepassword</code> parameter.
     *
     * @param value new value of <code>requirepassword</code>
     */
    public void setRequirepassword(boolean value) {
        requirepassword = value;
    }

    /**
     * Bean method to return the <code>requirelogout</code> parameter.
     *
     * @return String - returns the <code>requirelogout</code> parameter
     */
    public boolean getRequirelogout() {
        return requirelogout;
    }

    /**
     * Bean method to set the <code>requirelogout</code> parameter.
     *
     * @param value new value of <code>requirelogout</code>
     */
    public void setRequirelogout(boolean value) {
        requirelogout = value;
    }

    /**
     * Bean method to return the <code>requirelogin</code> parameter.
     *
     * @return String - returns the <code>requirelogin</code> parameter
     */
    public boolean getRequirelogin() {
        return requirelogin;
    }

    /**
     * Bean method to set the <code>requirelogin</code> parameter.
     *
     * @param value new value of <code>requirelogin</code>
     */
    public void setRequirelogin(boolean value) {
        requirelogin = value;
    }

    /**
     * Bean method to return the <code>width</code> parameter.
     *
     * @return String - returns the <code>width</code> parameter
     */
    public String getWidth() {
        return width;
    }

    /**
     * Bean method to set the <code>width</code> parameter.
     *
     * @param value new value of <code>width</code>
     */
    public void setWidth(String value) {
        width = value;
    }

    /**
     * Bean method to return the <code>textclass</code> parameter.
     *
     * @return String - returns the <code>textclass</code> parameter
     */
    public String getTextclass() {
        return textclass;
    }

    /**
     * Bean method to set the <code>textclass</code> parameter.
     *
     * @param value new value of <code>textclass</code>
     */
    public void setTextclass(String value) {
        textclass = value;
    }

    /**
     * Bean method to return the <code>tableexists</code> parameter.
     *
     * @return String - returns the <code>tableexists</code> parameter
     */
    public String getTableexists() {
        return tableexists;
    }

    /**
     * Bean method to set the <code>tableexists</code> parameter.
     *
     * @param value new value of <code>tableexists</code>
     */
    public void setTableexists(String value) {
        tableexists = value;
    }

    /**
     * Creates the login mask depending on the attributes.
     *
     * @param strOut string buffer which will receive the generated output
     */
    public void printLoginMask(StringBuffer strOut) {
        // create a form to insert username

        // open a new form
        strOut.append( "<form method=\"post\" action=\"" );
        strOut.append( ((HttpServletResponse)pageContext.getResponse()).encodeURL( "dispatcher" ) );
        strOut.append( "\">" );
        // create the input field for the command
        strOut.append( "<input name=\"cmd_login\" type=\"hidden\" value=\"true\">" );
        //create a new row
        strOut.append("<tr>");
        //create a new column
        strOut.append("<td width=\"100%\"" );
        // eventually set the css class
        if ( getTextclass() != null ) {
            strOut.append( " class=\"" + getTextclass() + "\"" );
        }
        // close column start tag
        strOut.append(" >");
        // create the input field for the username
        strOut.append( ( (Language) pageContext.getSession().getAttribute("language") ).getPhrase( "userlogin_nameinput_label" ) );
        // close the column and the row
        strOut.append("</td></tr>");
        //create a new row and column
        strOut.append("<tr><td width=\"100%\"" );
        // eventually set the css class
        if ( getTextclass() != null ) {
            strOut.append( " class=\"" + getTextclass() + "\"" );
        }
        // close column start tag
        strOut.append(" >");
        strOut.append( "<input name=\"username\" type=\"text\" size=\"25\" maxsize=\"100\">" );
        // close the column and row
        strOut.append("</td></tr>");
        //eventually create the input field for the password
        if ( getRequirepassword( ) ) {
            //create a new row
            strOut.append("<tr>");
            //create a new column
            strOut.append("<td width=\"100%\"" );
            // eventually set the css class
            if ( getTextclass() != null ) {
                strOut.append( " class=\"" + getTextclass() + "\"" );
            }
            // close column start tag
            strOut.append(" >");
            strOut.append( ( (Language) pageContext.getSession().getAttribute("language") ).getPhrase( "userlogin_passwordinput_label" ) );
            // close the column and the row
            strOut.append("</td></tr>");
            //create a new row and column
            strOut.append("<tr><td width=\"100%\"" );
            // eventually set the css class
            if ( getTextclass() != null ) {
                strOut.append( " class=\"" + getTextclass() + "\"" );
            }
            // close column start tag
            strOut.append(" >");
            // create the input field for the username
            strOut.append( "<input name=\"password\" type=\"password\" size=\"25\" maxsize=\"100\">" );
            // close the column and row
            strOut.append("</td></tr>");
        }
        // create the submit button
        strOut.append("<tr><td width=\"100%\" colspan=\"2\"" );
        // eventually set the css class
        if ( getTextclass() != null ) {
            strOut.append( " class=\"" + getTextclass() + "\"" );
        }
        // close column start tag
        strOut.append(" >");
        strOut.append( "<div align=\"center\">" );
        strOut.append( "<input type=\"submit\" value=\"" );
        strOut.append( ( (Language) pageContext.getSession().getAttribute("language") ).getPhrase( "menu_userlogin" ) );
        strOut.append( "\"</div>" );
        // close the column and row
        strOut.append("</td></tr>");
        //close the form
        strOut.append( "</form>" );
    }

    /**
     * Prints out the current user depending on the attributes.
     *
     * @param strOut string buffer which will receive the generated output
     * @param strUsername the name of the current user to print out
     */
    public void printCurrentUser( StringBuffer strOut, String strUsername ) {

        // first print the current user

        // open a new row and column
        strOut.append("<tr><td width=\"100%\"" );
        // eventually set the css class
        if ( getTextclass() != null ) {
            strOut.append( " class=\"" + getTextclass() + "\"" );
        }
        // close column start tag
        strOut.append(" >");
        // print the username
        strOut.append( ( (Language) pageContext.getSession().getAttribute("language") ).getPhrase( "userlogin_currentuser_label" ) );
        strOut.append( " " );
        strOut.append( strUsername );
        // close the column and row
        strOut.append("</td></tr>");

        //then print the logout link

        if ( getRequirelogout() ) {
            strOut.append("<tr><td width=\"100%\"" );
            // eventually set the css class
            if ( getTextclass() != null ) {
                strOut.append( " class=\"" + getTextclass() + "\"" );
            }
            // close column start tag
            strOut.append(" >");
            // print the logout link
            strOut.append( "<a href=\"" );
            strOut.append( ((HttpServletResponse)pageContext.getResponse()).encodeURL( "dispatcher?cmd_logout=true" ) );
            strOut.append("\">");
            strOut.append( ( (Language) pageContext.getSession().getAttribute("language") ).getPhrase( "userlogin_logout" ) );
            strOut.append("</a>");
            // close the column and row
            strOut.append("</td></tr>");
        }
    }

    /**
     * Creates either the login mask or print out the current user depending on the attributes.
     *
     * @param strOut string buffer which will receive the generated output
     */
    public void printLogin( StringBuffer strOut ) {
        if ( getForcelogin( ) ) {
            printLoginMask( strOut );
        }
        else {
            String username = (String)pageContext.getSession().getAttribute("userID");

            if ( ( username == null ) || ( ( "ANONYMOUS_USER".equals( username ) && ( getRequirelogin( ) ) ) ) ) {
                printLoginMask( strOut );
            }
            else {
                printCurrentUser( strOut, username );
            }
        }
    }

    /**
     * Depending on the <code>tableexists</code> attribute a new table will
     * be created. The width of the table is set to the <code>width</code> attribute.
     * Inside this table either the login  mask or the username will be displayed depending
     * on the used attributes.
     *
     * This method is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_INCLUDE if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {
        // create the table
        StringBuffer strOut = new StringBuffer();

        if (!"true".equals(getTableexists())) {
            strOut.append( "<table" );

            if ( width != null ) {
                strOut.append( " width=\"" + getWidth() + "\"" );
            }

            strOut.append( ">" );
        }

        printLogin( strOut );

        // a table might have been created
        if (!"true".equals(getTableexists())) {
            // close table
            strOut.append( "</table>" );
        }

        try {
            pageContext.getOut().print( strOut.toString() );
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }

        return EVAL_BODY_INCLUDE;
    }

    /**
     * This method is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     */
    public int doEndTag() {
        return EVAL_PAGE;
    }
}
