package de.fzi.wim.kaonportal.tags;

import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

import de.fzi.wim.kaonportal.multilingual.Language;

/**
 * This tag class creates a html table around the enclosed body text. The
 * table is a tabbed table with the title in the tab set to <code>title</code>.
 * The width of the table can be specified with the <code>width</code> attribute.
 * <code>titleclass</code> defines the css class for the title
 * and <code>contentclass</code> the css class for the data which is inserted
 * into the table. The tab will be aligned according to the orientation of the
 * currently selected language. All attributes are optional.
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class TabtableTag extends BodyTagSupport {

    /** property declaration for tag attribute: titleclass. */
    private String titleclass;

    /** property declaration for tag attribute: contentclass. */
    private String contentclass;

    /** property declaration for tag attribute: width. */
    private String width;

    /** property declaration for tag attribute: title. */
    private String title;

    /**
     * Bean method to return the <code>titleclass</code> parameter.
     *
     * @return String - returns the <code>titleclass</code> parameter
     */
    public String getTitleclass() {
        return titleclass;
    }

    /**
     * Bean method to set the <code>titleclass</code> parameter.
     *
     * @param value new value of <code>titleclass</code>
     */
    public void setTitleclass(String value) {
        titleclass = value;
    }

    /**
     * Bean method to return the <code>contentclass</code> parameter.
     *
     * @return String - returns the <code>contentclass</code> parameter
     */
    public String getContentclass() {
        return contentclass;
    }

    /**
     * Bean method to set the <code>contentclass</code> parameter.
     *
     * @param value new value of <code>contentclass</code>
     */
    public void setContentclass(String value) {
        contentclass = value;
    }

    /**
     * Bean method to return the <code>width</code> parameter.
     *
     * @return String - returns the <code>width</code> parameter
     */
    public String getWidth() {
        return width;
    }

    /**
     * Bean method to set the <code>width</code> parameter.
     *
     * @param value new value of <code>width</code>
     */
    public void setWidth(String value) {
        width = value;
    }

    /**
     * Bean method to return the <code>title</code> parameter.
     *
     * @return String - returns the <code>title</code> parameter
     */
    public String getTitle() {
        return title;
    }

    /**
     * Bean method to set the <code>title</code> parameter.
     *
     * @param value new value of <code>title</code>
     */
    public void setTitle(String value) {
        title = value;
    }

    /**
     * This method starts the tabbed table with the specified parameters.
     *
     * It is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {
        // retrieve the orientation
        HttpSession session = pageContext.getSession();
        Language lelem = (Language) session.getAttribute("language");
        String strorientation = "";

        if ( lelem != null ) {
            strorientation = lelem.getOrientation();
            if ( strorientation == null ) {
                strorientation = "";
            }
        }

        // create the table
        StringBuffer strOut = new StringBuffer();
        strOut.append( "<table" );

        if ( width != null ) {
            strOut.append( " width=\"" + width + "\"" );
        }

        strOut.append( " cellpadding=\"0\" cellspacing=\"0\">" );

        // create the 3 column row with the title
        strOut.append( "<tr><td" );

        if ( titleclass != null ) {
            strOut.append( " class=\"" + titleclass + "\"" );
        }

        if ( "rtl".equals( strorientation ) ) {
            strOut.append( " style=\"background-position:right\"" );
        }
        else if ( "ltr".equals( strorientation ) ) {
            strOut.append( " style=\"background-position:left\"" );
        }

        strOut.append( ">" );
        if ( title != null ) {
            strOut.append( title );
        }
        strOut.append( "</td></tr><tr><td" );
        if ( contentclass != null ) {
            strOut.append( " class=\"" + contentclass + "\"" );
        }
        strOut.append( ">" );

        try {
            pageContext.getOut().print( strOut.toString() );
        }
        catch (IOException e) {
            throw new JspException(e);
        }

        return EVAL_BODY_BUFFERED;
    }

    /**
     * This method closes the table after the body.
     *
     * It is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     * @throws JspException will be thrown when some error occures
     */
    public int doEndTag() throws JspException {
        try {
            pageContext.getOut().print( "</td></tr></table>" );
        }
        catch (Exception e) {
            throw new JspException(e);
        }

        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in TabtableTag: " + ex);
        }

        return SKIP_BODY;
    }
}
