package de.fzi.wim.kaonportal.tags;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import de.fzi.wim.kaonportal.OntologyAccess;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.Concept;
import edu.unika.aifb.kaon.api.oimodel.Instance;
import edu.unika.aifb.kaon.api.oimodel.OIModel;
import edu.unika.aifb.kaon.api.vocabulary.KAONVocabularyAdaptor;

/**
 * @author zach
 * 11.09.2003
 */
public class SelectInstanceTag implements Tag{

    private String lan;
    private String uri;
    private PageContext context;
    private Tag parent;
    private OIModel ont;

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#setPageContext(javax.servlet.jsp.PageContext)
     */
    public void setPageContext(PageContext arg0) {
        this.context = arg0;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#setParent(javax.servlet.jsp.tagext.Tag)
     */
    public void setParent(Tag arg0) {
        parent = arg0;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#getParent()
     */
    public Tag getParent() {
        return parent;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri (){
        return uri;
    }

    public void setLan(String lan) {
        this.lan = lan;
    }

    public String getLan() {
        return lan;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#doStartTag()
     */
    public int doStartTag() {
        return EVAL_BODY_INCLUDE;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#doEndTag()
     */
    public int doEndTag() throws JspException {
        try {
            ont = ((OntologyAccess) context.getRequest().getAttribute("ontologyaccess")).getOIModel();
            Concept conc = ont.getConcept(uri);
            Set insts = conc.getAllInstances();
            Iterator it = insts.iterator();
            String languageURI = KAONVocabularyAdaptor.INSTANCE.getLanguageURI(lan);
            while (it.hasNext()) {
                Instance current = (Instance) it.next();
                context.getOut().println("<option value=\""+current.getURI()+"\">"+current.getLabel(languageURI)+"</option>");
            }

        } catch (KAONException e) {
            throw new JspException(e.getMessage());
        } catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return EVAL_PAGE;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#release()
     */
    public void release() {
    }
}
