package de.fzi.wim.kaonportal.tags;

import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;
import javax.servlet.jsp.tagext.VariableInfo;

import de.fzi.wim.kaonportal.multilingual.Language;

/**
 * This tag class either prints out the orientation string or exports a scripting
 * variable with the name specified in the <code>output</code> attribute.
 * The orientation will be generated for the currently activated language.
 *
 * @see de.fzi.wim.kaonportal.tags.OrientationTag.OrientationTagTEI
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class OrientationTag extends BodyTagSupport {

    /** property declaration for tag attribute: output. */
    private String output;

    /**
     * This TagExtraInfo class serves as handler for the scripting variables
     * of the <code>OrientationTag</code> class.
     *
     * @see de.fzi.wim.kaonportal.tags.OrientationTag
     * @author Tammo Riedinger
     */
    public static class OrientationTagTEI extends AbstractTEI {

        /**
         *
         * Creates a new <code>OrientationTagTEI</code> object
         * and registers the variables supported be the <code>OrientationTag</code>
         *
         * @throws JspException will be thrown when some error occures while creating the object
         */
        public OrientationTagTEI() throws JspException{
            super();

            // register variables to export
            addVariable( "output", "java.lang.String", true, VariableInfo.NESTED );
        }
    }

    /**
     * Bean method to return the <code>output</code> parameter.
     *
     * @return String - returns the <code>output</code> parameter
     */
    public String getOutput() {
        return output;
    }

    /**
     * Bean method to set the <code>output</code> parameter.
     *
     * @param value new value of <code>output</code> parameter
     */
    public void setOutput(String value) {
        output = value;
    }

    /**
     * This method prints out the orientation string or copies it to the variable specified with the <code>output</code> attribute.
     *
     * It is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {
        String value = "";
        HttpSession session = pageContext.getSession();
        Language lelem = (Language) session.getAttribute("language");

        if ( lelem != null ) {
            value = lelem.getOrientation();
        }

        // print the orientation to the servlet or copy it to the scripting variable
        if ( getOutput() != null ) {
            pageContext.setAttribute( getOutput(), value );
        }
        else {
            try {
                pageContext.getOut().print( value );
            }
            catch (IOException e) {
                throw new JspException(e);
            }
        }

        return EVAL_BODY_BUFFERED;
    }

    /**
     * This method is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     */
    public int doEndTag() {
        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in OrientationTag: " + ex);
        }

        return SKIP_BODY;
    }

}
