package de.fzi.wim.kaonportal.tags;

import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.util.Iterator;

/**
 * This tag class is used as a flow control tag. It's body will only be included if the supplied iterator
 * has no more elements.
 *
 * @version 13-06-2002
 * @author Tammo Riedinger
 */
public class OnNotHasElementsTag extends AbstractIteratorConsumer {

    /**
     * If the supplied iterator's <code>hasNext</code> function returns <code>false</code> the body will
     * be included. It won't be included otherwise.
     *
     * This method is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     */
    public int doStartTag() {
        // check if we have read the iterator from the page context
        if ( getIteratorname() != null ) {
            Iterator it = (Iterator) pageContext.getAttribute( getIteratorname() );

            if ( it != null ) {
                addIterator( it );
            }
        }

        if ( !getIterator().hasNext() ) {
            return EVAL_BODY_BUFFERED;
        }
        else {
            return SKIP_BODY;
        }
    }

    /**
     * This method is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     */
    public int doEndTag() {
        return EVAL_PAGE;
    }

    /**
     *
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in OnNotHasElementsTag: " + ex);
        }

        return SKIP_BODY;
    }
}
