package de.fzi.wim.kaonportal.tags;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

/**
 * This tag class creates a box around the enclosed body text. The
 * box has a title set to <code>title</code>. Depending on the attribute
 * <code>tableexists</code> it can be embedded into an existing table
 * or can create it's own table.
 * The width of that table can be specified with the <code>width</code> attribute.
 * <code>titleclass</code> defines the css class for the title
 * and <code>contentclass</code> the css class for the data which is inserted
 * into the box. All attributes are optional.
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class MenuItemTag extends BodyTagSupport {

    /** property declaration for tag attribute: titleclass. */
    private String titleclass;

    /** property declaration for tag attribute: contentclass. */
    private String contentclass;

    /** property declaration for tag attribute: width. */
    private String width;

    /** property declaration for tag attribute: title. */
    private String title;

    /** property declaration for tag attribute: tableexists. */
    private String tableexists;

    /**
     * Bean method to return the <code>titleclass</code> parameter.
     *
     * @return String - returns the <code>titleclass</code> parameter
     */
    public String getTitleclass() {
        return titleclass;
    }

    /**
     * Bean method to set the <code>titleclass</code> parameter.
     *
     * @param value new value of <code>titleclass</code>
     */
    public void setTitleclass(String value) {
        titleclass = value;
    }

    /**
     * Bean method to return the <code>tableexists</code> parameter.
     *
     * @return String - returns the <code>tableexists</code> parameter
     */
    public String getTableexists() {
        return tableexists;
    }

    /**
     * Bean method to set the <code>tableexists</code> parameter.
     *
     * @param value new value of <code>tableexists</code>
     */
    public void setTableexists(String value) {
        tableexists = value;
    }

    /**
     * Bean method to return the <code>contentclass</code> parameter.
     *
     * @return String - returns the <code>contentclass</code> parameter
     */
    public String getContentclass() {
        return contentclass;
    }

    /**
     * Bean method to set the <code>contentclass</code> parameter.
     *
     * @param value new value of <code>contentclass</code>
     */
    public void setContentclass(String value) {
        contentclass = value;
    }

    /**
     * Bean method to return the <code>width</code> parameter.
     *
     * @return String - returns the <code>width</code> parameter
     */
    public String getWidth() {
        return width;
    }

    /**
     * Bean method to set the <code>width</code> parameter.
     *
     * @param value new value of <code>width</code>
     */
    public void setWidth(String value) {
        width = value;
    }

    /**
     * Bean method to return the <code>title</code> parameter.
     *
     * @return String - returns the <code>title</code> parameter
     */
    public String getTitle() {
        return title;
    }

    /**
     * Bean method to set the <code>title</code> parameter.
     *
     * @param value new value of <code>title</code>
     */
    public void setTitle(String value) {
        title = value;
    }

    /**
     * This method starts the box with the specified parameters.
     *
     * It is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {
        StringBuffer strOut = new StringBuffer();

        // create the table
        if (!"true".equals(getTableexists())) {
            strOut.append( "<table" );

            if ( width != null ) {
                strOut.append( " width=\"" + width + "\"" );
            }

            strOut.append( " cellpadding=\"0\" cellspacing=\"0\">" );
        }

        // create the row for the title (3 columns)
        strOut.append( "<tr><td" );
        if ( getTitleclass() != null ) {
            strOut.append( " class=\"" + getTitleclass() + "\"" );
        }
        strOut.append( ">" );
        // print the title
        if ( getTitle() != null ) {
            strOut.append( getTitle() );
        }
        strOut.append( "</td></tr>" );

        // create a row for the content (3 columns)
        // it will be closed after the body
        strOut.append( "<tr><td" );
        if ( getTitleclass() != null ) {
            strOut.append( " class=\"" + getContentclass() + "\"" );
        }
        strOut.append( ">");

        try {
            pageContext.getOut().print( strOut.toString() );
        }
        catch (IOException e) {
            throw new JspException(e);
        }

        return EVAL_BODY_BUFFERED;
    }

    /**
     * This method closes the table after the body.
     *
     * It is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     * @throws JspException will be thrown when some error occures
     */
    public int doEndTag() throws JspException {
        // close content column, add a vline and close the row
        StringBuffer strOut = new StringBuffer();
        strOut.append( "</td></tr>" );
        if (!"true".equals(getTableexists())) {
            strOut.append( "</table>" );
        }
        try {
            pageContext.getOut().print( strOut.toString() );
        }
        catch (Exception e) {
            throw new JspException(e);
        }

        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in MenuItemTag: " + ex);
        }

        return SKIP_BODY;
    }
}
