package de.fzi.wim.kaonportal.tags;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

/**
 * This tag class formats the text in its body according to a specified cssclass.
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class HeadlineTag extends BodyTagSupport {

    /** property declaration for tag attribute: cssclass. */
    private String cssclass;

    /**
     *
     * Bean method to return the <code>cssclass</code> parameter.
     *
     * @return String - returns the <code>cssclass</code> parameter
     */
    public String getCssclass() {
        return cssclass;
    }

    /**
     *
     * Bean method to set the <code>cssclass</code> parameter.
     *
     * @param value new value of <code>cssclass</code>
     */
    public void setCssclass(String value) {
        cssclass = value;
    }

    /**
     * This method opens a <code>div</code> with the specified css class (if any) to wrap the body of the tag.
     *
     * It is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {

        // open div-tag
        StringBuffer strOut = new StringBuffer();
        strOut.append( "<div " );

        if ( cssclass != null ) {
            strOut.append( "class=\"" + cssclass + "\"" );
        }

        strOut.append( ">" );

        try {
            pageContext.getOut().print( strOut.toString() );
        }//try
        catch (Exception e) {
            throw new JspException( e.getMessage() );
        }//catch

        return EVAL_BODY_BUFFERED;
    }

    /**
     * This method closes the <code>div</code> after the body.
     *
     * It is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     * @throws JspException will be thrown when some error occures
     */
    public int doEndTag() throws JspException {
        // close div-tag
        StringBuffer strOut = new StringBuffer();
        strOut.append( "</div>" );

        try {
            pageContext.getOut().print( strOut.toString() );
        }//try
        catch (Exception e) {
            throw new JspException( e.getMessage() );
        }//catch

        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in HeadlineTag: " + ex);
        }

        return SKIP_BODY;
    }
}
