package de.fzi.wim.kaonportal.tags;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;
import javax.servlet.jsp.tagext.VariableInfo;

/**
 * This tag class either prints out the formatted url or exports it to a scripting
 * variable with the name specified in the <code>output</code> attribute.
 *
 * @see de.fzi.wim.kaonportal.tags.FormatUrlTag.FormatUrlTagTEI
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class FormatUrlTag extends BodyTagSupport {

    /** property declaration for tag attribute: output. */
    private String output;

    /** property declaration for tag attribute: url. */
    private String url;

    /**
     * This TagExtraInfo class serves as handler for the scripting variables
     * of the <code>FormatUrlTag</code> class.
     *
     * @see de.fzi.wim.kaonportal.tags.FormatUrlTag
     * @author Tammo Riedinger
     */
    public static class FormatUrlTagTEI extends AbstractTEI {

        /**
         *
         * Creates a new <code>FormatUrlTagTEI</code> object
         * and registers the variables supported be the <code>FormatUrlTag</code>
         *
         * @throws JspException will be thrown when some error occures while creating the object
         */
        public FormatUrlTagTEI() throws JspException{
            super();

            // register variables to export
            addVariable( "output", "java.lang.String", true, VariableInfo.NESTED );
        }
    }

    /**
     * Bean method to return the <code>output</code> parameter.
     *
     * @return String - returns the <code>output</code> parameter
     */
    public String getOutput() {
        return output;
    }

    /**
     * Bean method to set the <code>output</code> parameter.
     *
     * @param value new value of <code>output</code> parameter
     */
    public void setOutput(String value) {
        output = value;
    }

    /**
     * Bean method to return the <code>url</code> parameter.
     *
     * @return String - returns the <code>url</code> parameter
     */
    public String getUrl() {
        return url;
    }

    /**
     * Bean method to set the <code>url</code> parameter.
     *
     * @param value new value of <code>url</code> parameter
     */
    public void setUrl(String value) {
        url = value;
    }

    /**
     * This method prints out the encoded url or copies it to the variable specified with the <code>output</code> attribute.
     *
     * It is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {
        String value = "";

        value = ((HttpServletResponse)pageContext.getResponse()).encodeURL( getUrl() );

        // print the orientation to the servlet or copy it to the scripting variable
        if ( getOutput() != null ) {
            pageContext.setAttribute( getOutput(), value );
        }
        else {
            try {
                pageContext.getOut().print( value );
            }
            catch (IOException e) {
                throw new JspException(e);
            }
        }

        return EVAL_BODY_BUFFERED;
    }

    /**
     * This method is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     */
    public int doEndTag() {
        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in FormatUrlTag: " + ex);
        }

        return SKIP_BODY;
    }

}
