package de.fzi.wim.kaonportal.tags;

import java.io.IOException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import edu.unika.aifb.kaon.api.KAONException;
import de.fzi.wim.kaonportal.OntologyFormatter;
import de.fzi.wim.kaonportal.tree.EntityHierarchyTree;
import de.fzi.wim.kaonportal.tree.TreeNode;
import de.fzi.wim.kaonportal.tree.TreeException;

/**
 * This tag prints out the entity tree.
 */
public class EntityTreeTag extends AbstractObjectAccess {

    /** property declaration for tag attribute: treeid. */
    private String treeid;
    /** property declaration for tag attribute: plus. */
    private String plus;
    /** property declaration for tag attribute: minus. */
    private String minus;
    /** property declaration for tag attribute: indent. */
    private int indent=20;
    /** property declaration for tag attribute: classname. */
    private String classname;
    /** property declaration for tag attribute: treeclassname. */
    private String treeclassname;

    /**
     * Initialiyes default properties of the tag.
     */
    public EntityTreeTag() {
        treeclassname = "de.fzi.wim.kaonportal.tree.EntityHierarchyTree";
    }
    /**
     * Bean method to return the <code>treeid</code> parameter.
     *
     * @return String - returns the <code>treeid</code> parameter
     */
    public String getTreeid() {
        return treeid;
    }

    /**
     * Bean method to set the <code>treeid</code> parameter.
     *
     * @param value new value of <code>treeid</code> parameter
     */
    public void setTreeid(String value) {
        treeid = value;
    }

    /**
     * Bean method to return the <code>plus</code> parameter.
     *
     * @return String - returns the <code>plus</code> parameter
     */
    public String getPlus() {
        return plus;
    }

    /**
     * Bean method to set the <code>plus</code> parameter.
     *
     * @param value new value of <code>plus</code> parameter
     */
    public void setPlus(String value) {
        plus = value;
    }

    /**
     * Bean method to return the <code>minus</code> parameter.
     *
     * @return String - returns the <code>minus</code> parameter
     */
    public String getMinus() {
        return minus;
    }

    /**
     * Bean method to set the <code>minus</code> parameter.
     *
     * @param value new value of <code>minus</code> parameter
     */
    public void setMinus(String value) {
        minus = value;
    }

    /**
     * Bean method to return the <code>indent</code> parameter.
     *
     * @return String - returns the <code>indent</code> parameter
     */
    public int getIndent() {
        return indent;
    }

    /**
     * Bean method to set the <code>indent</code> parameter.
     *
     * @param value new value of <code>indent</code> parameter
     */
    public void setIndent(int value) {
        indent = value;
    }

    /**
     * Bean method to return the <code>classname</code> parameter.
     *
     * @return String - returns the <code>classname</code> parameter
     */
    public String getClassname() {
        return classname;
    }

    /**
     * Bean method to set the <code>classname</code> parameter.
     *
     * @param value new value of <code>classname</code> parameter
     */
    public void setClassname(String value) {
        classname = value;
    }

    /**
     * Bean method to return the <code>treeclassname</code> parameter.
     *
     * @return String - returns the <code>treeclassname</code> parameter
     */
    public String getTreeclassname() {
        return treeclassname;
    }

    /**
     * Bean method to set the <code>treeclassname</code> parameter.
     *
     * @param value new value of <code>treeclassname</code> parameter
     */
    public void setTreeclassname(String value) {
        treeclassname = value;
    }

    /**
     * This method outputs creates the tree if it doesn't exist and outputs it.
     *
     * It is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() throws JspException {
        try {
            EntityHierarchyTree tree=(EntityHierarchyTree)pageContext.getSession().getAttribute(treeid);
            if (tree==null) {
                Class treeClass=Class.forName(treeclassname);
                tree=(EntityHierarchyTree)treeClass.newInstance();
                tree.refresh();
                pageContext.getSession().setAttribute(treeid,tree);
            }
            synchronized (tree) {
                tree.setOntologyAccess(getOntologyAccess());
                OntologyFormatter formatter=getOntologyFormatter();
                pageContext.getOut().println("<table border='0' cellspacing='0' cellpadding='0'>");
                printNode(tree,(EntityHierarchyTree.EntityTreeNode)tree.getRoot(),0,formatter);
                pageContext.getOut().println("</table>");
            }
        }
        catch (TreeException e) {
            throw new JspException(e);
        }
        catch (IOException e) {
            throw new JspException(e);
        }
        catch (ClassNotFoundException e) {
            throw new JspException(e);
        }
        catch (InstantiationException e) {
            throw new JspException(e);
        }
        catch (IllegalAccessException e) {
            throw new JspException(e);
        }
        return EVAL_BODY_BUFFERED;
    }

    /**
     * Prints the node of the tree.
     *
     * @param node the node
     * @param tree the tree
     * @param level the current indentation level
     * @param ontologyFormatter the formatter
     * @throws TreeException if there is an error
     * @throws IOException if there is an error
     */
    protected void printNode(EntityHierarchyTree tree,EntityHierarchyTree.EntityTreeNode node,int level,OntologyFormatter ontologyFormatter) throws TreeException,IOException {
        pageContext.getOut().print("<tr><td style='padding-left: "+level+"px'");
        if (classname!=null)
            pageContext.getOut().print(" class='"+classname+"'");
        pageContext.getOut().print(">");
        // we must make sure we first load the children so that we know for sure whether the node is leaf
        TreeNode[] children=null;
        if (node.getExpanded())
            children=tree.getNodeChildren(node);
        if (!node.isLeaf()) {
            String actionname;
            String imageName;
            if (node.getExpanded()) {
                actionname="cmd_collapsetreenode";
                imageName=minus;
            }
            else {
                actionname="cmd_expandtreenode";
                imageName=plus;
            }
            pageContext.getOut().print("<a href='"+OntologyFormatter.JSP_FILE+"?"+actionname+"=true&treeid="+treeid+"&nodeid="+node.getID()+"'><img src='"+imageName+"'></a>");
        }
        String label=node.getLabel(ontologyFormatter.getLanguageURI());
        pageContext.getOut().print(ontologyFormatter.formatObject(node.getEntityURI(),label));
        pageContext.getOut().println("</td></tr>");
        if (children!=null)
            for (int i=0;i<children.length;i++)
                printNode(tree,(EntityHierarchyTree.EntityTreeNode)children[i],level+indent,ontologyFormatter);
    }

    /**
     * This method is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     */
    public int doEndTag() {
        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in EntityTreeTag: " + ex);
        }

        return SKIP_BODY;
    }
}
