package de.fzi.wim.kaonportal.tags;

import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

import de.fzi.wim.kaonportal.OntologyFormatter;
import edu.unika.aifb.kaon.api.oimodel.Concept;
import edu.unika.aifb.kaon.api.oimodel.Property;
import edu.unika.aifb.kaon.api.oimodel.Instance;

/**
 * This tag class retrieves and prints out the lexical attribute of the current <code>Entity</code> object.
 * The current object will be retrieved either from the page context or from the supplied uri and type.
 * This tag is valid for all objects of type <code>Entity</code>
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public class EntityLexicalAttributeTag extends AbstractObjectAccess {

    protected String lexicalAttributeURI;

    public void setLexicalAttributeURI(String lexicalAttributeURI) {
            this.lexicalAttributeURI = lexicalAttributeURI;
    }

    public String getLexicalAttributeURI() {
            return lexicalAttributeURI;
    }

    /**
     * This method is called when the JSP engine encounters the start tag,
     * after the attributes are processed.
     * Scripting variables (if any) have their values set here.
     *
     * @return EVAL_BODY_BUFFERED if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doStartTag() {
        return EVAL_BODY_BUFFERED;
    }

    /**
     * This method decides which object to retrieve the lexical attribute from and prints the value out.
     *
     * It is called after the JSP engine finished processing the tag.
     *
     * @return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.
     * @throws JspException will be thrown when some error occures
     */
    public int doEndTag() throws JspException {
        OntologyFormatter format=getOntologyFormatter();
        String value=null;
        Instance instance=getInstance();
        if (instance!=null)
            value=format.getLexicalAttribute(instance,lexicalAttributeURI);
        else {
            Concept concept=getConcept();
            if (concept!=null)
                value=format.getLexicalAttribute(concept,lexicalAttributeURI);
            else {
                Property property=getProperty();
                if (property!=null)
                    value=format.getLexicalAttribute(property,lexicalAttributeURI);
            }
        }
        if (value==null)
            throw new JspException("Cannot load lexical attribute of current object.");
        try {
            pageContext.getOut().print(value);
        }
        catch (IOException e) {
            throw new JspException(e);
        }

        return EVAL_PAGE;
    }

    /**
     * This method is called after the JSP engine processes the body content of the tag.
     * If the tag's bodyContent is set to "empty," then this method
     * will not be called.
     *
     * @return EVAL_BODY_TAG if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.
     * @throws JspException will be thrown when some error occures
     */
    public int doAfterBody() throws JspException {
        try {
            JspWriter out = getPreviousOut();
            BodyContent bodyContent = getBodyContent();

            bodyContent.writeOut(out);
            bodyContent.clearBody();

        } catch (Exception ex) {
            throw new JspException("error in EntityLexicalAttributeTag: " + ex);
        }

        return SKIP_BODY;
    }

}
