package de.fzi.wim.kaonportal.tags;

import java.util.LinkedList;
import java.util.List;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import de.fzi.wim.kaonportal.OntologyAccess;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.change.AddEntity;
import edu.unika.aifb.kaon.api.change.AddInstanceOf;
import edu.unika.aifb.kaon.api.change.AddPropertyInstance;
import edu.unika.aifb.kaon.api.oimodel.Concept;
import edu.unika.aifb.kaon.api.oimodel.Instance;
import edu.unika.aifb.kaon.api.oimodel.LexicalEntry;
import edu.unika.aifb.kaon.api.oimodel.OIModel;
import edu.unika.aifb.kaon.api.oimodel.Property;
import edu.unika.aifb.kaon.api.util.LexiconUtil;
import edu.unika.aifb.kaon.api.vocabulary.KAONVocabularyAdaptor;

/**
 * @author zach
 * 11.09.2003
 */
public class CreateInstance implements Tag {

    private PageContext context;
    private Tag parent;
    private String uri = null;
    private List changes;
    private Instance inst;
    private OIModel ont;


    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#setPageContext(javax.servlet.jsp.PageContext)
     */
    public void setPageContext(PageContext arg0) {
        this.context = arg0;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#setParent(javax.servlet.jsp.tagext.Tag)
     */
    public void setParent(Tag arg0) {
        this.parent = arg0;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#getParent()
     */
    public Tag getParent() {
        return parent;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return uri;
    }

    protected void addLabel (String text, String lan) throws KAONException {
        LexicalEntry entry = ont.getLexicalEntry(ont.createNewURI());
        LexiconUtil.createLexicalEntry(
            entry,
            KAONVocabularyAdaptor.INSTANCE.getKAONLabel(),
            text,
            KAONVocabularyAdaptor.INSTANCE.getLanguageURI(lan),
            inst, changes);
    }

    protected void addAttribute (String attributeUri, String text) throws KAONException {
        Property property = ont.getProperty(attributeUri);
        AddPropertyInstance adp = new AddPropertyInstance(property, inst, text);
        changes.add(adp);
    }

    protected void addRelation (String relationUri, String targetInstanceUri) throws KAONException {
        Property property = ont.getProperty(relationUri);
        Instance targetInstance = ont.getInstance(targetInstanceUri);
        AddPropertyInstance adp = new AddPropertyInstance(property, inst, targetInstance);
        changes.add(adp);
    }

    protected void addSuperClass (String superClassUri) throws KAONException {
        Concept concept = ont.getConcept(superClassUri);
        changes.add(new AddInstanceOf(concept,inst));
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#doStartTag()
     */
    public int doStartTag() throws JspException {
        ont = ((OntologyAccess) context.getRequest().getAttribute("ontologyaccess")).getOIModel();
        changes = new LinkedList();
        try {
            if (uri == null) uri = ont.createNewURI();
            context.getRequest().setAttribute("instanceUri", uri);
            inst = ont.getInstance(uri);
            if (!inst.isInOIModel()) {
                changes.add(new AddEntity(inst));
            }
        } catch (KAONException ke) {
            throw new JspException(ke.getMessage());
        }
        return EVAL_BODY_INCLUDE;
    }


    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#doEndTag()
     */
    public int doEndTag() throws JspException {
        uri = null;
        try {
            ont.applyChanges(changes);
            ont.save();
        } catch (KAONException e) {
            throw new JspException(e.getMessage());
        }
        return EVAL_PAGE;
    }

    /* (non-Javadoc)
     * @see javax.servlet.jsp.tagext.Tag#release()
     */
    public void release() {
    }


}
