package de.fzi.wim.kaonportal.tags;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.http.HttpServletResponse;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.Concept;
import edu.unika.aifb.kaon.api.oimodel.Property;
import edu.unika.aifb.kaon.api.oimodel.Instance;

import de.fzi.wim.kaonportal.OntologyFormatter;
import de.fzi.wim.kaonportal.OntologyAccess;
import de.fzi.wim.kaonportal.Dispatcher;
import de.fzi.wim.kaonportal.multilingual.Language;

/**
 * Common base class for all tags that access objects. It provides the bean
 * methods for the <code>uri</code> and <code>type</code> attributes, which
 * can then be used in the tag to specify an entity that should be loaded
 * ( add attribute variables called "uri" and "type" in the tld file for a tag
 * extending this class ). If parameters are provided to the tag,
 * the current object from the session context will be retrieved.
 *
 * @version 08-05-2002
 * @author Tammo Riedinger
 */
public abstract class AbstractObjectAccess extends BodyTagSupport {

    /** property declaration for tag attribute: uri. */
    private String uri;

    /**
     * Bean method to return the <code>uri</code> parameter.
     *
     * @return String - returns the <code>uri</code> parameter
     */
    public String getUri() {
        return uri;
    }

    /**
     * Bean method to set the <code>uri</code> parameter.
     *
     * @param value new value of <code>uri</code> parameter
     */
    public void setUri(String value) {
        uri = value;
    }

    /**
     * This function returns the specified concept.
     *
     * @return                      the concept with given URI
     * @throws JspException will be thrown if an object cannot be found
     */
    protected Concept getConcept() throws JspException {
        OntologyAccess access = getOntologyAccess();
        if ( getUri() != null  && getUri().length() > 0 ) {
            try {
                return access.getConcept(getUri());
            }
            catch (KAONException e) {
                throw new JspException(e);
            }
        }
        else {
            return (Concept)pageContext.getRequest().getAttribute("currentConcept");
        }
    }

    /**
     * This function returns the specified property.
     *
     * @return                      the property with given URI
     * @throws JspException will be thrown if an object cannot be found
     */
    protected Property getProperty() throws JspException {
        OntologyAccess access = getOntologyAccess();
        if ( getUri() != null  && getUri().length() > 0 ) {
            try {
                return access.getProperty(getUri());
            }
            catch (KAONException e) {
                throw new JspException(e);
            }
        }
        else {
            return (Property)pageContext.getRequest().getAttribute("currentProperty");
        }
    }

    /**
     * This function returns the specified instance.
     *
     * @return                      the instance with given URI
     * @throws JspException will be thrown if an object cannot be found
     */
    protected Instance getInstance() throws JspException {
        OntologyAccess access = getOntologyAccess();
        if ( getUri() != null  && getUri().length() > 0 ) {
            try {
                return access.getInstance(getUri());
            }
            catch (KAONException e) {
                throw new JspException(e);
            }
        }
        else {
            return (Instance)pageContext.getRequest().getAttribute("currentInstance");
        }
    }

    /**
     * This function creates an <code>OntologyFormatter</code> object for
     * the current language and ontology.
     *
     * @return                  returns the created <code>OntologyFormatter</code> object
     */
    protected OntologyFormatter getOntologyFormatter() {
        Language language = (Language) pageContext.getSession().getAttribute("language");
        OntologyAccess access = getOntologyAccess();
        Dispatcher.OntologyFormatterFactory factory=(Dispatcher.OntologyFormatterFactory)pageContext.getServletContext().getAttribute("ontologyformatterfactory");
        return factory.createOntologyFormatter(access, language.getLocale().getLanguage(), (HttpServletResponse)pageContext.getResponse());
    }

    /**
     * Returns the current ontology access.
     *
     * @return                  the current ontology access object
     */
    protected OntologyAccess getOntologyAccess() {
        return (OntologyAccess)pageContext.getRequest().getAttribute("ontologyaccess");
    }
}
