package de.fzi.wim.kaonportal.logging;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

import de.fzi.wim.kaonportal.OntologyInfo;

/**
 * Default event logger that doesn't do anything.
 *
 * @author Tammo Riedinger
 * @version 1.0
 */
public class NullEventLogger implements EventLogger {
    /** Static instance of this class. */
    public static final NullEventLogger INSTANCE=new NullEventLogger();

    /**
     * Creates an instance of this class.
     */
    public NullEventLogger() {
    }
    /**
     * Starts up the logger.
     *
     * @param parameters        the map of parameters
     * @param physicalURI       the physical URI of the model
     * @param logicalURI        the logical URI of the model
     * @throws ServletException     thrown if there is an error
     */
    public void startup(Map parameters,String physicalURI,String logicalURI) {
    }
    /**
     * Terminates the logger.
     */
    public void shutDown() {
    }
    /**
     * Generic logging command.
     *
     * @param request           the request
     * @param command           command
     */
    public void logCommand(HttpServletRequest request,String command) {
    }
    /**
     * Logs the fact that the user started a search.
     *
     * @param request           the request
     * @param searchString      search string
     */
    public void logSearch(HttpServletRequest request,String searchString) {
    }
    /**
     * Logs the search results.
     *
     * @param request           the request
     * @param searchString      search string
     * @param searchResults     the search results
     */
    public void logSearchResults(HttpServletRequest request,String searchString,Collection searchResults) {
    }
    /**
     * Logs the fact that the user selected an object.
     *
     * @param request           the request
     * @param uri               URI of the object that was selected
     */
    public void logObjectSelected(HttpServletRequest request,String uri) {
    }
    /**
     * Logs the fact that the user changed the language.
     *
     * @param request           the request
     * @param locale            new locale
     */
    public void logChangeLanguage(HttpServletRequest request,Locale locale) {
    }
    /**
     * Logs the fact that the user has changed the ontology.
     *
     * @param request           the request
     * @param ontologyInfo      new ontology
     */
    public void logChangeOntology(HttpServletRequest request,OntologyInfo ontologyInfo) {
    }
}
