package de.fzi.wim.kaonportal.logging;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import de.fzi.wim.kaonportal.OntologyInfo;

/**
 * This interface defines all methods for logging purposes.
 *
 * @author Tammo Riedinger
 * @version 1.0
 */
public interface EventLogger {
    /**
     * Starts up the logger.
     *
     * @param parameters        the map of parameters
     * @param physicalURI       the physical URI of the model
     * @param logicalURI        the logical URI of the model
     * @throws ServletException     thrown if there is an error
     */
    void startup(Map parameters,String physicalURI,String logicalURI) throws ServletException;
    /**
     * Terminates the logger.
     *
     * @throws ServletException     thrown if there is an error
     */
    void shutDown() throws ServletException;
    /**
     * Generic logging command.
     *
     * @param request           the request
     * @param command           command
     * @throws IOException      thrown if an error occures while logging the data
     */
    void logCommand(HttpServletRequest request,String command) throws IOException;
    /**
     * Logs the fact that the user started a search.
     *
     * @param request           the request
     * @param searchString      search string
     * @throws IOException      thrown if an error occures while logging the data
     */
    void logSearch(HttpServletRequest request,String searchString) throws IOException;
    /**
     * Logs the search results.
     *
     * @param request           the request
     * @param searchString      search string
     * @param searchResults     the search results
     * @throws IOException      thrown if an error occures while logging the data
     */
    void logSearchResults(HttpServletRequest request,String searchString,Collection searchResults) throws IOException;
    /**
     * Logs the fact that the user selected an object.
     *
     * @param request           the request
     * @param uri               URI of the object that was selected
     * @throws IOException      thrown if an error occures while logging the data
     */
    void logObjectSelected(HttpServletRequest request,String uri) throws IOException;
    /**
     * Logs the fact that the user changed the language.
     *
     * @param request           the request
     * @param locale            new locale
     * @throws IOException      thrown if an error occures while logging the data
     */
    void logChangeLanguage(HttpServletRequest request,Locale locale) throws IOException;
    /**
     * Logs the fact that the user has changed the ontology.
     *
     * @param request           the request
     * @param ontologyInfo      new ontology
     * @throws IOException      thrown if an error occures while logging the data
     */
    void logChangeOntology(HttpServletRequest request,OntologyInfo ontologyInfo) throws IOException;
}
