package de.fzi.wim.kaonportal;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;

/**
 * Storage of several ontologies.
 */
public class OntologyStore {
    private Map m_ontologyStore;
    private List m_ontologies;
    private OntologyInfo m_defaultOntology;

    public OntologyStore() {
        m_ontologyStore = new HashMap();
        m_ontologies = new LinkedList();
    }
    public synchronized void addOntology(String name,String physicalURI,String defaultLanguage,Map connectionParameters,boolean computeSimilarity,boolean isDefault,String eventLoggerClass,String usageLogLogicalURI,String usageLogPhysicalURI,Map usageLogParameters) throws KAONException {
        if (!m_ontologyStore.containsKey(physicalURI)) {
            OntologyInfo ontologyInfo=new OntologyInfo(name,physicalURI,defaultLanguage,connectionParameters,computeSimilarity,eventLoggerClass,usageLogLogicalURI,usageLogPhysicalURI,usageLogParameters);
            m_ontologyStore.put(physicalURI,ontologyInfo);
            m_ontologies.add(ontologyInfo);
            if (isDefault)
                m_defaultOntology=ontologyInfo;
        }
    }
    public synchronized OntologyInfo getOntologyInfo(String physicalURI) {
        return (OntologyInfo)m_ontologyStore.get(physicalURI);
    }
    public synchronized List getOntologies() {
        return m_ontologies;
    }
    public synchronized OntologyInfo getDefaultOntology() {
        return m_defaultOntology;
    }
    public synchronized void uninitialize() {
        Iterator onotologyInfos=m_ontologyStore.values().iterator();
        while (onotologyInfos.hasNext()) {
            OntologyInfo ontologyInfo=(OntologyInfo)onotologyInfos.next();
            ontologyInfo.uninitialize();
        }
    }
}
