package de.fzi.wim.kaonportal;

import java.util.Map;
import javax.servlet.ServletException;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.kaonportal.logging.*;

/**
 * A class offering some convenient methods for the viewer jsp to access an ontology
 *
 * @author Valentin Zacharias
 */
public class OntologyInfo {
    protected String m_name;
    protected String m_physicalURI;
    protected String m_defaultLanguage;
    protected Map m_connectionParameters;
    protected String m_usageLogLogicalURI;
    protected String m_usageLogPhysicalURI;
    protected Map m_usageLogParameters;
    protected boolean m_computeSimilarity;
    protected KAONConnection m_connection;
    protected EventLogger m_eventLogger;

    public OntologyInfo(String name,String physicalURI,String defaultLanguage,Map connectionParameters,boolean computeSimilarity,String eventLoggerClass,String usageLogLogicalURI,String usageLogPhysicalURI,Map usageLogParameters) throws KAONException {
        m_name=name;
        m_physicalURI=physicalURI;
        m_connectionParameters=connectionParameters;
        m_defaultLanguage=defaultLanguage;
        m_computeSimilarity=computeSimilarity;
        try {
            m_eventLogger=(EventLogger)Class.forName(eventLoggerClass).newInstance();
        }
        catch (Exception e) {
            throw new KAONException("Cannot instantiate event logger.",e);
        }
        m_usageLogLogicalURI=usageLogLogicalURI;
        m_usageLogPhysicalURI=usageLogPhysicalURI;
        m_usageLogParameters=usageLogParameters;
    }
    public void initialize() throws KAONException,ServletException {
        if (m_connection==null) {
            m_connection=KAONManager.getKAONConnection(m_connectionParameters);
            m_eventLogger.startup(m_usageLogParameters,m_usageLogPhysicalURI,m_usageLogLogicalURI);
        }
    }
    public void uninitialize() {
        if (m_connection!=null) {
            try {
                m_connection.close();
                m_eventLogger.shutDown();
            }
            catch (Exception ignored) {
            }
        }
        m_connection=null;
    }
    public String getName() {
        return m_name;
    }
    public String getPhysicalURI() {
        return m_physicalURI;
    }
    public String getDefaultLanguage() {
        return m_defaultLanguage;
    }
    public OntologyAccess createAccess() throws KAONException {
        return new OntologyAccess(this,m_connection.getConnection(),getPhysicalURI(),m_computeSimilarity);
    }
    public EventLogger getEventLogger() {
        return m_eventLogger;
    }
}
