package de.fzi.wim.kaonportal;

import java.util.List;
import java.util.Set;
import java.util.HashSet;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Collection;
import java.util.Collections;

import de.fzi.wim.similarity.Similarity;
import de.fzi.wim.similarity.SimilarityImpl;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.Concept;
import edu.unika.aifb.kaon.api.oimodel.Property;
import edu.unika.aifb.kaon.api.oimodel.Instance;
import edu.unika.aifb.kaon.api.oimodel.OIModel;
import edu.unika.aifb.kaon.api.oimodel.KAONConnection;

/**
 * A class offering some convenient methods for the viewer jsp to access an ontology
 *
 * @author Valentin Zacharias
 */
public class OntologyAccess {
    protected OntologyInfo m_ontologyInfo;
    protected KAONConnection m_connection;
    protected OIModel m_oimodel;
    protected Similarity m_similarity;
    protected Map m_allFromPropertyValuesCache;

    public OntologyAccess(OntologyInfo ontologyInfo,KAONConnection connection,String physicalURI,boolean computeSimilarity) throws KAONException{
        m_ontologyInfo=ontologyInfo;
        m_connection=connection;
        m_oimodel=m_connection.openOIModelPhysical(physicalURI);
        if (computeSimilarity)
            m_similarity=new SimilarityImpl(m_oimodel);
    }

    public OIModel getOIModel() {
        return m_oimodel;
    }

    public Concept getConcept(String uri)  throws KAONException {
        return m_oimodel.getConcept(uri);
    }

    public Property getProperty(String uri)  throws KAONException {
        return m_oimodel.getProperty(uri);
    }

    public Instance getInstance(String uri)  throws KAONException {
        return m_oimodel.getInstance(uri);
    }

    public List getSimilar(Instance instance) throws KAONException {
        if (m_similarity==null)
            return Collections.EMPTY_LIST;
        else
            return m_similarity.getMostSimilar(instance);
    }

    public Collection getMatchingEntities(String languageURI,String searchString) throws KAONException {
        return m_oimodel.executeQuery("HAS_LABEL('"+searchString+"') OR HAS_LEXICON('Synonym','"+searchString+"')");
    }

    public Set getToValuesForProperty(Instance instance,Property property) throws KAONException {
        Set toReturn = new HashSet();
        if (!property.isAttribute()) {
            Iterator propertyValues = instance.getFromPropertyValues(property).iterator();
            while (propertyValues.hasNext()) {
                Object value=propertyValues.next();
                if (value instanceof Instance)
                    toReturn.add(value);
            }
        }
        return toReturn;
    }

    public void close() {
        try {
            m_connection.close();
        }
        catch (KAONException ignored) {
        }
    }

    public Map getAllFromPropertyValues(Instance instance) throws KAONException {
        // this is cached for each instance, since it can take a lot of time to compute this map
        if (m_allFromPropertyValuesCache==null)
            m_allFromPropertyValuesCache=new HashMap();
        Map allFromPropertyValues=(Map)m_allFromPropertyValuesCache.get(instance.getURI());
        if (allFromPropertyValues==null) {
            allFromPropertyValues=instance.getAllFromPropertyValues();
            m_allFromPropertyValuesCache.put(instance.getURI(),allFromPropertyValues);
        }
        return allFromPropertyValues;
    }

    public String getDefaultLanguage () {
        return m_ontologyInfo.getDefaultLanguage();
    }
}
