package de.fzi.wim.kaonportal;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.Properties;

/**
 * Auxiliary class for reading environment variables.
 *
 * @author  Tammo Riedinger
 */
public class Environment {
    /**
     * This function returns the commands that need to be executed to retrieve the
     * environment variables.
     * <br>
     * <b>!!!To be fixed!!!</b> - for mac os versions < 9 there is yet no way to
     * retrieve the environment variables.
     *
     * @return String - command to execute
     */
    private static String getEnvironmentVariablesCommand() {
        String osname = System.getProperty("os.name").toLowerCase();
        if ( osname.indexOf("mac os") >= 0 ) {
            // Mac
            // Determine if we are running under OS X
            try {
                String version = System.getProperty("os.version");
                int majorVersion = Integer.parseInt(version.substring(0, version.indexOf('.')));

                if (majorVersion >= 10) {
                    // OS X - just line UNIX
                    return "/usr/bin/env";
                }
            } catch (NumberFormatException e) {
                // fall through to OS 9
            }
            // OS 9 and previous
            // TO DO: I have no idea how to get it, someone must fix it
            return null;
        }
        else if ( osname.indexOf("os/2") >= 0 ) {
            // OS/2 - use same mechanism as Windows 2000
            // Not sure
            return "cmd /c set";
        }
        else if ( osname.indexOf("indows") >= 0 ) {
            // Determine if we're running under XP/2000/NT or 98/95
            if ( osname.indexOf("nt") >= 0 || osname.indexOf("2000") >= 0 || osname.indexOf("xp") >= 0) {
                // Windows 2000/NT
                return "cmd /c set";
            }
            else {
                // Windows 98/95 - need to use an auxiliary script
                return "command.com /c set";
            }
        }
        else {
            // Generic UNIX
            // Alternatively one could use: /bin/sh -c env
            return "/usr/bin/env";
        }
    }

    /**
     * This function reads all environment variables into a properties object.
     *
     * @return Properties - all environment variables
     * @throws IOException will be thrown if some i/o error occures
     */
    public static Properties getEnvironmentVariables() throws IOException {
        Runtime r = Runtime.getRuntime();
        Properties envVars = new Properties();
        Process p = r.exec( getEnvironmentVariablesCommand() );

        BufferedReader in = new BufferedReader( new InputStreamReader( p.getInputStream() ) );

        String var = null;
        String line, lineSep = System.getProperty("line.separator");
        while ((line = in.readLine()) != null) {
            if ( line.indexOf('=') == -1) {
                // Chunk part of previous env var (UNIX env vars can contain embedded new lines).
                if (var == null) {
                    var = lineSep + line;
                }
                else {
                    var += lineSep + line;
                }
            }
            else {
                var = line;

                int idx = var.indexOf('=');
                String key = var.substring( 0, idx );
                String value = var.substring( idx+1 );
                envVars.setProperty( key, value );
            }
        }
        // Since we "look ahead" before adding, there's one last env var.
        int idx = var.indexOf('=');
        String key = var.substring( 0, idx );
        String value = var.substring( idx+1 );
        envVars.setProperty( key, value );

        return envVars;
    }

    /**
     * This function reads the environment variables and finds the
     * value for the specified variable.
     *
     * @param strVarname name of the variable to retrieve
     * @return String - value of the found variable
     * @throws IOException will be thrown if some i/o error occures
     */
    public static String getEnvironmentVariable(String strVarname) throws IOException {
        Properties p = getEnvironmentVariables();
        return p.getProperty(strVarname);
    }
}
