package edu.unika.aifb.kaon.virtualoimodel.test;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.virtualoimodel.*;

/**
 * Abstract class for all tests based on text.xml file.
 */
public abstract class VirtualTestXMLTest extends VirtualBaseTest {
    protected static Model s_testModel;
    static {
        try {
            s_testModel=RDFManager.openModel(VirtualBaseTest.class.getResource("res/test.xml").toString(),null);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_testModel=null;
        }
    }

    protected VirtualConcept m_root;
    protected VirtualConcept m_person;
    protected VirtualConcept m_student;
    protected VirtualConcept m_phdStudent;
    protected VirtualConcept m_hiwi;
    protected VirtualConcept m_employee;
    protected VirtualConcept m_project;
    protected VirtualConcept m_institution;
    protected VirtualProperty m_name;
    protected VirtualProperty m_address;
    protected VirtualProperty m_cooperates_with;
    protected VirtualProperty m_works_at;
    protected VirtualProperty m_student_works_at;
    protected VirtualProperty m_phdStudent_works_at;
    protected VirtualProperty m_hasProject;
    protected VirtualInstance m_personLjiljana;
    protected VirtualInstance m_personBoris;
    protected VirtualInstance m_personAlex;
    protected VirtualInstance m_projectOntoLogging;
    protected VirtualInstance m_phdStudentInstance;
    protected VirtualLexicalEntry m_person_label_en;
    protected VirtualLexicalEntry m_person_label_de;
    protected VirtualLexicalEntry m_person_documentation_en;
    protected VirtualLexicalEntry m_name_label_en;

    public VirtualTestXMLTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        super.setUp();
        m_root=(VirtualConcept)m_virtualOIModel.getRootConcept();
        m_person=(VirtualConcept)m_virtualOIModel.getConcept("test:Person");
        m_student=(VirtualConcept)m_virtualOIModel.getConcept("test:Student");
        m_phdStudent=(VirtualConcept)m_virtualOIModel.getConcept("test:PhDStudent");
        m_hiwi=(VirtualConcept)m_virtualOIModel.getConcept("test:HiWi");
        m_employee=(VirtualConcept)m_virtualOIModel.getConcept("test:Employee");
        m_project=(VirtualConcept)m_virtualOIModel.getConcept("test:Project");
        m_institution=(VirtualConcept)m_virtualOIModel.getConcept("test:Institution");
        m_name=(VirtualProperty)m_virtualOIModel.getProperty("test:name");
        m_address=(VirtualProperty)m_virtualOIModel.getProperty("test:address");
        m_cooperates_with=(VirtualProperty)m_virtualOIModel.getProperty("test:cooperates_with");
        m_works_at=(VirtualProperty)m_virtualOIModel.getProperty("test:works_at");
        m_student_works_at=(VirtualProperty)m_virtualOIModel.getProperty("test:student_works_at");
        m_phdStudent_works_at=(VirtualProperty)m_virtualOIModel.getProperty("test:PhDstudent_works_at");
        m_hasProject=(VirtualProperty)m_virtualOIModel.getProperty("test:has_Project");
        m_personLjiljana=(VirtualInstance)m_virtualOIModel.getInstance("test:122");
        m_personBoris=(VirtualInstance)m_virtualOIModel.getInstance("test:127");
        m_personAlex=(VirtualInstance)m_virtualOIModel.getInstance("test:131");
        m_projectOntoLogging=(VirtualInstance)m_virtualOIModel.getInstance("test:137");
        m_phdStudentInstance=(VirtualInstance)m_virtualOIModel.getInstance("test:142");
        m_person_label_en=(VirtualLexicalEntry)m_virtualOIModel.getLexicalEntry("test:61");
        m_person_label_de=(VirtualLexicalEntry)m_virtualOIModel.getLexicalEntry("test:11161");
        m_person_documentation_en=(VirtualLexicalEntry)m_virtualOIModel.getLexicalEntry("test:22261");
        m_name_label_en=(VirtualLexicalEntry)m_virtualOIModel.getLexicalEntry("test:91");
    }
    protected Model getDefaultModel() {
        return s_testModel;
    }
}
