package edu.unika.aifb.kaon.virtualoimodel.test;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import edu.unika.aifb.kaon.virtualoimodel.*;

public class VirtualPropertyTest extends VirtualTestXMLTest {

    public VirtualPropertyTest(String name) {
        super(name);
    }
    public void testGetProperty() throws Exception {
        Property name=m_oimodel.getProperty("test:name");
        assertEquals(name,((VirtualProperty)m_virtualOIModel.getProperty("test:name")).getProperty());
        assertSame(name,m_name.getProperty());
    }
    public void testIsInOIModel() throws Exception {
        assertTrue(m_name.isInOIModel());
        assertTrue(!m_oimodel.getProperty("test:non-existent").isInOIModel());
        assertTrue(!m_virtualOIModel.getProperty("test:non-existent").isInOIModel());
    }
    public void testGetDomainConcepts() throws Exception {
        assertSetEquals(m_name.getDomainConcepts(),new Object[] { m_person,m_institution });
        assertSetEquals(m_hasProject.getDomainConcepts(),new Object[] { m_project });
    }
    public void testIsDomainConcept() throws Exception {
        assertTrue(m_name.isDomainConcept(m_person));
        assertTrue(!m_name.isDomainConcept(m_project));
        assertTrue(m_name.isDomainConcept(m_person));
    }
    public void testGetRangeConcepts() throws Exception {
        assertSetEquals(m_works_at.getRangeConcepts(),new Object[] { m_project });
        assertSetEquals(m_name.getRangeConcepts(),null);
    }
    public void testIsAttribute() throws Exception {
        assertTrue(m_name.isAttribute());
        assertTrue(!m_works_at.isAttribute());
    }
    public void testGetSubProperties() throws Exception {
        assertSetEquals(m_works_at.getSubProperties(),new Object[] { m_student_works_at });
        assertSetEquals(m_name.getSubProperties(),null);
    }
    public void testGetSuperProperties() throws Exception {
        assertSetEquals(m_student_works_at.getSuperProperties(),new Object[] { m_works_at });
        assertSetEquals(m_name.getSuperProperties(),null);
    }
    public void testGetAllSubProperties() throws Exception {
        assertSetEquals(m_works_at.getAllSubProperties(),new Object[] { m_student_works_at,m_phdStudent_works_at });
        assertSetEquals(m_name.getAllSubProperties(),null);
    }
    public void testGetAllSuperProperties() throws Exception {
        assertSetEquals(m_phdStudent_works_at.getAllSuperProperties(),new Object[] { m_student_works_at,m_works_at });
        assertSetEquals(m_name.getAllSuperProperties(),null);
    }
    public void testIsSubProperty() throws Exception {
        assertTrue(m_student_works_at.isSubPropertyOf(m_works_at));
        assertTrue(m_phdStudent_works_at.isSubPropertyOf(m_works_at));
        assertTrue(m_phdStudent_works_at.isSubPropertyOf(m_student_works_at));
        assertTrue(!m_student_works_at.isSubPropertyOf(m_student_works_at));
        assertTrue(!m_student_works_at.isSubPropertyOf(m_phdStudent_works_at));
    }
    public void testIsDirectSub() throws Exception {
        assertTrue(m_student_works_at.isDirectSubPropertyOf(m_works_at));
        assertTrue(!m_phdStudent_works_at.isDirectSubPropertyOf(m_works_at));
        assertTrue(m_phdStudent_works_at.isDirectSubPropertyOf(m_student_works_at));
    }
    public void testPropertyInstances() throws Exception {
        assertSetEquals(m_cooperates_with.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personBoris,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personBoris),
        });
    }
    public void testGetURI() throws Exception {
        assertEquals("test:name",m_name.getURI());
    }
    public void testAddProperty() throws Exception {
        VirtualProperty hates=(VirtualProperty)m_virtualOIModel.getProperty("test:hates");
        assertTrue(!hates.isInOIModel());
        applyChanges(new ChangeEvent[] { new AddPropertyDomain(hates,m_person),new AddPropertyRange(hates,m_person),new AddEntity(hates) });
        assertTrue(hates.isInOIModel());
        assertSetEquals(hates.getDomainConcepts(),new Object[] { m_person });
        assertSetEquals(hates.getRangeConcepts(),new Object[] { m_person });
        assertEquals(0,hates.getMinimumCardinality(m_person));
        assertEquals(Integer.MAX_VALUE,hates.getMaximumCardinality(m_person));
        assertTrue(!m_oimodel.getConcept("test:hates").isInOIModel());
    }
    public void testRemovePropertyNoTestFirst() throws Exception {
        applyChanges(new ChangeEvent[] { new RemovePropertyDomain(m_name,m_institution),new RemovePropertyDomain(m_name,m_person),new RemoveEntity(m_name) });
        assertSetEquals(m_name.getDomainConcepts(),null);
        assertTrue(!m_name.isInOIModel());
        assertTrue(m_oimodel.getProperty("test:name").isInOIModel());
    }
    public void testRemovePropertyTestFirst() throws Exception {
        assertSetEquals(m_name.getDomainConcepts(),new Object[] { m_person,m_institution });
        assertTrue(m_name.isInOIModel());
        testRemovePropertyNoTestFirst();
    }
    public void testRemovePropertyRangeNoTestFirst() throws Exception {
        applyChanges(new ChangeEvent[] { new RemovePropertyRange(m_cooperates_with,m_person) });
        assertSetEquals(m_cooperates_with.getRangeConcepts(),null);
    }
    public void testRemovePropertyRangeTestFirst() throws Exception {
        assertSetEquals(m_cooperates_with.getRangeConcepts(),new Object[] { m_person });
        testRemovePropertyRangeNoTestFirst();
    }
    public void testAddSubPropertyNoTestFirst() throws Exception {
        VirtualProperty hasFailedProject=(VirtualProperty)m_virtualOIModel.getProperty("test:has_failed_project");
        applyChanges(new ChangeEvent[] { new AddEntity(hasFailedProject),new AddSubProperty(m_hasProject,hasFailedProject) });
        assertSetEquals(hasFailedProject.getSuperProperties(),new Object[] { m_hasProject });
        assertSetEquals(m_hasProject.getSubProperties(),new Object[] { hasFailedProject });
        assertTrue(hasFailedProject.isInOIModel());
    }
    public void testAddSubPropertyTestFirst() throws Exception {
        VirtualProperty hasFailedProject=(VirtualProperty)m_virtualOIModel.getProperty("test:has_failed_project");
        assertSetEquals(m_hasProject.getSubProperties(),null);
        assertTrue(!hasFailedProject.isInOIModel());
        testAddSubPropertyNoTestFirst();
    }
    public void testSetCardinalityNoTestFirst() throws Exception {
        applyChanges(new ChangeEvent[] { new SetMinimumCardinality(m_name,m_institution,2),new SetMaximumCardinality(m_name,m_institution,5) });
        assertEquals(2,m_name.getMinimumCardinality(m_institution));
        assertEquals(5,m_name.getMaximumCardinality(m_institution));
    }
    public void testSetCardinalityTestFirst() throws Exception {
        assertEquals(0,m_name.getMinimumCardinality(m_institution));
        assertEquals(Integer.MAX_VALUE,m_name.getMaximumCardinality(m_institution));
        testSetCardinalityNoTestFirst();
    }
    public void testSetInverseProperties() throws Exception {
        VirtualProperty projectStaff=(VirtualProperty)m_virtualOIModel.getProperty("test:project_staff");
        assertTrue(!projectStaff.isInOIModel());
        applyChanges(new ChangeEvent[] { new AddEntity(projectStaff),new AddPropertyDomain(projectStaff,m_project),new AddPropertyRange(projectStaff,m_person) });
        assertTrue(projectStaff.isInOIModel());
        assertNull(m_works_at.getInverseProperty());
        assertNull(projectStaff.getInverseProperty());
        applyChange(new SetInverseProperties(m_works_at,projectStaff));
        assertSame(m_works_at.getInverseProperty(),projectStaff);
        assertSame(projectStaff.getInverseProperty(),m_works_at);
        applyChange(new SetNoInverseProperties(m_works_at,m_works_at.getInverseProperty()));
        assertNull(m_works_at.getInverseProperty());
        assertNull(projectStaff.getInverseProperty());
    }
    public void testSetTransitiveProperty() throws Exception {
        assertTrue(!m_works_at.isTransitive());
        applyChange(new SetPropertyTransitive(m_works_at,true));
        assertTrue(m_works_at.isTransitive());
    }
    public void testSetSymmetricProperty() throws Exception {
        assertTrue(!m_works_at.isSymmetric());
        applyChange(new SetPropertySymmetric(m_works_at,true));
        assertTrue(m_works_at.isSymmetric());
    }
}