package edu.unika.aifb.kaon.virtualoimodel.test;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import edu.unika.aifb.kaon.virtualoimodel.*;

public class VirtualOIModelTest extends VirtualTestXMLTest {

    public VirtualOIModelTest(String name) {
        super(name);
    }
    public void testGetConcepts() throws Exception {
        assertSetEquals(m_virtualOIModel.getConcepts(),new Object[] { m_root,m_person,m_student,m_phdStudent,m_hiwi,m_employee,m_project,m_institution });
    }
    public void testGetConceptsAfterRemove() throws Exception {
        applyChanges(new ChangeEvent[] { new RemoveSubConcept(m_student,m_hiwi),new RemoveEntity(m_hiwi) });
        assertSetEquals(m_virtualOIModel.getConcepts(),new Object[] { m_root,m_person,m_student,m_phdStudent,m_employee,m_project,m_institution });
    }
    public void testGetConceptsAfterAdd() throws Exception {
        VirtualConcept failedProject=(VirtualConcept)m_virtualOIModel.getConcept("test:failed_project");
        applyChanges(new ChangeEvent[] { new AddEntity(failedProject),new AddSubConcept(m_project,failedProject) });
        assertSetEquals(m_virtualOIModel.getConcepts(),new Object[] { m_root,m_person,m_student,m_phdStudent,m_hiwi,failedProject,m_employee,m_project,m_institution });
    }
    public void testOriginalOIModel() throws Exception {
        assertEquals(m_oimodel,m_virtualOIModel.getOIModel());
    }
    public void testGetProperties() throws Exception {
        assertSetEquals(m_virtualOIModel.getProperties(),new Object[] { m_name,m_address,m_cooperates_with,m_works_at,m_student_works_at,m_phdStudent_works_at,m_hasProject });
    }
    public void testGetPropertiesAfterRemove() throws Exception {
        applyChanges(new ChangeEvent[] { new RemovePropertyDomain(m_hasProject,m_project),new RemovePropertyRange(m_hasProject,m_project),new RemoveEntity(m_hasProject) });
        assertSetEquals(m_virtualOIModel.getProperties(),new Object[] { m_name,m_address,m_cooperates_with,m_works_at,m_student_works_at,m_phdStudent_works_at });
    }
    public void testGetPropertiesAfterAdd() throws Exception {
        VirtualProperty hates=(VirtualProperty)m_virtualOIModel.getProperty("test:hates");
        applyChanges(new ChangeEvent[] { new AddPropertyDomain(hates,m_person),new AddPropertyRange(hates,m_person),new AddEntity(hates) });
        assertSetEquals(m_virtualOIModel.getProperties(),new Object[] { m_name,m_address,m_cooperates_with,m_works_at,m_student_works_at,m_phdStudent_works_at,m_hasProject,hates });
    }
}