package edu.unika.aifb.kaon.virtualoimodel.test;

import java.util.Map;
import java.util.Collections;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.vocabulary.*;
import edu.unika.aifb.kaon.apionrdf.*;
import edu.unika.aifb.kaon.virtualoimodel.*;

public class VirtualLexicalEntryTest extends VirtualTestXMLTest {

    public VirtualLexicalEntryTest(String name) {
        super(name);
    }
    protected OIModel setUpOIModel(Model model) throws Exception {
        OIModel oimodel=m_kaonConnection.getOIModelForRDFModel(model);
        oimodel.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_kaonConnection.openOIModelLogical(KAONConnection.LEXICAL_OIMODEL_URI))));
        return oimodel;
    }
    public void testGetLexicalEntry() throws Exception {
        LexicalEntry lexicalEntry=m_oimodel.getLexicalEntry("test:61");
        assertSame(m_person_label_en.getInstance(),lexicalEntry);
    }
    public void testIsInOIModel() throws Exception {
        assertTrue(m_person_label_en.isInOIModel());
        assertTrue(!m_oimodel.getLexicalEntry("test:non-existent").isInOIModel());
        assertTrue(!m_virtualOIModel.getLexicalEntry("test:non-existent").isInOIModel());
    }
    public void testGetURI() throws Exception {
        assertEquals("test:61",m_person_label_en.getURI());
    }
    public void testGetReferencedEntitiesConcepts() throws Exception {
        assertSetEquals(m_person_label_en.getReferencedEntities(),new Object[] { m_person.getSpanningInstance() });
        assertSetEquals(m_person.getLexicalEntries(),new Object[] { m_person_label_en,m_person_label_de,m_person_documentation_en });
    }
    public void testGetReferencedEntitiesRelations() throws Exception {
        assertSetEquals(m_name_label_en.getReferencedEntities(),new Object[] { m_name.getSpanningInstance() });
        assertSetEquals(m_name.getLexicalEntries(),new Object[] { m_name_label_en });
    }
    public void testGetAttributeValues() throws Exception {
        Map map=m_person_label_en.getAttributeValues();
        assertEquals(2,map.size());
        assertEquals(m_virtualOIModel.getInstance(EN),map.get(KAON_inLanguage));
        assertEquals("Person",map.get(VALUE));
    }
    public void testGetAttribute() throws Exception {
        assertEquals("Person",m_person_label_en.getAttribute(VALUE));
    }
    public void testGetTypeURI() throws Exception {
        assertEquals(KAON_Label,m_person_label_en.getTypeURI());
    }
    public void testVirtualEntity() throws Exception {
        assertSame(m_person_label_en,m_person.getLexicalEntry(KAON_Label,EN));
        assertSame(m_person_label_de,m_person.getLexicalEntry(KAON_Label,DE));
        assertEquals("Person",m_person.getLexicalAttribute(KAON_Label,EN,VALUE));
        assertEquals("Die Person",m_person.getLexicalAttribute(KAON_Label,DE,VALUE));
        assertEquals("Person",m_person.getLabel(EN));
        assertEquals("Die Person",m_person.getLabel(DE));
        assertSetEquals(m_person.getLexicalEntries(KAON_Label),new Object[] { m_person_label_en,m_person_label_de });
        assertEquals("Documentation Person",m_person.getLexicalAttribute(KAON_Documentation,EN,VALUE));
        assertSame(m_person_label_en,m_person.getLexicalEntry(KAON_Label,EN));
        assertSame(m_person_label_de,m_person.getLexicalEntry(KAON_Label,DE));
    }
}