package edu.unika.aifb.kaon.virtualoimodel.test;

import java.util.Map;
import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import edu.unika.aifb.kaon.virtualoimodel.*;

public class VirtualInstanceTest extends VirtualTestXMLTest {

    public VirtualInstanceTest(String name) {
        super(name);
    }
    public void testGetInstance() throws Exception {
        Instance instance=m_oimodel.getInstance("test:122");
        assertEquals(instance,((VirtualInstance)m_virtualOIModel.getInstance("test:122")).getInstance());
        assertSame(instance,m_personLjiljana.getInstance());
    }
    public void testIsInOIModel() throws Exception {
        assertTrue(m_personLjiljana.isInOIModel());
        assertTrue(!m_oimodel.getInstance("test:non-existent").isInOIModel());
        assertTrue(!m_virtualOIModel.getInstance("test:non-existent").isInOIModel());
    }
    public void testGetURI() throws Exception {
        assertEquals("test:122",m_personLjiljana.getURI());
    }
    public void testGetParentConcepts() throws Exception {
        assertSetEquals(m_personLjiljana.getParentConcepts(),new Object[] { m_person,m_root });
        assertSetEquals(m_person.getInstances(),new Object[] { m_personLjiljana,m_personAlex,m_personBoris });
        VirtualConcept virtualConcept=(VirtualConcept)m_virtualOIModel.getConcept("test:NewPerson");
        assertTrue(!m_personLjiljana.getParentConcepts().contains(virtualConcept));
        assertSetEquals(virtualConcept.getInstances(),null);
        applyChanges(new ChangeEvent[] { new AddEntity(virtualConcept),new AddInstanceOf(virtualConcept,m_personLjiljana) });
        assertSetEquals(m_personLjiljana.getParentConcepts(),new Object[] { m_person,virtualConcept,m_root });
        assertSetEquals(virtualConcept.getInstances(),new Object[] { m_personLjiljana });
    }
    public void testGetFromPropertyInstances() throws Exception {
        assertSetEquals(m_personLjiljana.getFromPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic"),
            m_virtualOIModel.getPropertyInstance(m_address,m_personLjiljana,"Vorholz Str. 28"),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personLjiljana,m_projectOntoLogging),
        });
        assertSetEquals(m_name.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personBoris,"Boris Motik"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_name,m_phdStudentInstance,"Generic student"),
        });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana 2");
        applyChange(new AddPropertyInstance(propertyInstance));
        assertSetEquals(m_personLjiljana.getFromPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana 2"),
            m_virtualOIModel.getPropertyInstance(m_address,m_personLjiljana,"Vorholz Str. 28"),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personLjiljana,m_projectOntoLogging),
        });
        assertSetEquals(m_name.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana 2"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personBoris,"Boris Motik"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_name,m_phdStudentInstance,"Generic student"),
        });
    }
    public void testGetFromPropertyValues() throws Exception {
        assertNull(m_personLjiljana.getFromPropertyValue(m_hasProject));
        assertEquals("Ljiljana Stojanovic",m_personLjiljana.getFromPropertyValue(m_name));
        Map map=m_personLjiljana.getFromPropertyValues();
        assertEquals(4,map.size());
        assertSetEquals((Set)map.get(m_name),new Object[] { "Ljiljana Stojanovic" });
        assertSetEquals((Set)map.get(m_address),new Object[] { "Vorholz Str. 28" });
        assertSetEquals((Set)map.get(m_cooperates_with),new Object[] { m_personAlex });
        assertSetEquals((Set)map.get(m_works_at),new Object[] { m_projectOntoLogging });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana 2");
        applyChange(new AddPropertyInstance(propertyInstance));
        map=m_personLjiljana.getFromPropertyValues();
        assertEquals(4,map.size());
        assertSetEquals((Set)map.get(m_name),new Object[] { "Ljiljana Stojanovic","Ljiljana 2"});
        assertSetEquals((Set)map.get(m_address),new Object[] { "Vorholz Str. 28" });
        assertSetEquals((Set)map.get(m_cooperates_with),new Object[] { m_personAlex });
        assertSetEquals((Set)map.get(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "Ljiljana Stojanovic","Ljiljana 2"});
    }
    public void testGetToPropertyInstances() throws Exception {
        assertSetEquals(m_personLjiljana.getToPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
        });
        assertSetEquals(m_projectOntoLogging.getToPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personAlex,m_projectOntoLogging),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personLjiljana,m_projectOntoLogging),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personBoris,m_projectOntoLogging),
        });
        VirtualInstance newInstance=(VirtualInstance)m_virtualOIModel.getInstance("test:newInstance");
        assertSetEquals(newInstance.getFromPropertyInstances(),null);
        assertSetEquals(newInstance.getToPropertyInstances(),null);
        applyChanges(new ChangeEvent[] { new AddEntity(newInstance),new AddInstanceOf(m_person,newInstance) });
        assertSetEquals(m_person.getAllInstances(),new Object[] { m_personLjiljana,m_personAlex,m_personBoris,m_phdStudentInstance,newInstance });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_works_at,newInstance,m_projectOntoLogging);
        applyChange(new AddPropertyInstance(propertyInstance));
        assertSetEquals(m_projectOntoLogging.getToPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personAlex,m_projectOntoLogging),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personLjiljana,m_projectOntoLogging),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personBoris,m_projectOntoLogging),
            propertyInstance,
        });
        assertSetEquals(newInstance.getFromPropertyInstances(),new Object[] { propertyInstance });
    }
    public void testGetNonExistentProperty() throws Exception {
        assertTrue(m_personLjiljana.getFromPropertyValues(m_hasProject).isEmpty());
        assertTrue(m_personLjiljana.getToPropertyValues(m_hasProject).isEmpty());
    }
    public void testGetToPropertyValues() throws Exception {
        Map map=m_personLjiljana.getToPropertyValues();
        assertSetEquals((Set)map.get(m_cooperates_with),new Object[] { m_personAlex });
        assertEquals(1,map.size());
        map=m_projectOntoLogging.getToPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_works_at),new Object[] { m_personAlex,m_personLjiljana,m_personBoris });
        VirtualInstance newInstance=(VirtualInstance)m_virtualOIModel.getInstance("test:newInstance");
        assertEquals(0,newInstance.getFromPropertyValues().size());
        assertEquals(0,newInstance.getToPropertyValues().size());
        applyChanges(new ChangeEvent[] { new AddEntity(newInstance),new AddInstanceOf(m_person,newInstance) });
        assertSetEquals(m_person.getAllInstances(),new Object[] { m_personLjiljana,m_personAlex,m_personBoris,m_phdStudentInstance,newInstance });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_works_at,newInstance,m_projectOntoLogging);
        applyChange(new AddPropertyInstance(propertyInstance));
        map=m_projectOntoLogging.getToPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_works_at),new Object[] { m_personAlex,m_personLjiljana,m_personBoris,newInstance });
    }
    public void testRemovePropertyValue1() throws Exception {
        assertSetEquals(m_name.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personBoris,"Boris Motik"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_name,m_phdStudentInstance,"Generic student"),
        });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic");
        applyChange(new RemovePropertyInstance(propertyInstance));
        assertSetEquals(m_personLjiljana.getFromPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_address,m_personLjiljana,"Vorholz Str. 28"),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personLjiljana,m_projectOntoLogging),
        });
        Map map=m_personLjiljana.getFromPropertyValues();
        assertEquals(3,map.size());
        assertSetEquals((Set)map.get(m_address),new Object[] { "Vorholz Str. 28" });
        assertSetEquals((Set)map.get(m_cooperates_with),new Object[] { m_personAlex });
        assertSetEquals((Set)map.get(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_name.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personBoris,"Boris Motik"),
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_name,m_phdStudentInstance,"Generic student"),
        });
    }
    public void testRemovePropertyValue2() throws Exception {
        Map map=m_personLjiljana.getToPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_cooperates_with),new Object[] { m_personAlex });
        assertSetEquals(m_personAlex.getFromPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_address,m_personAlex,"FZI"),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personBoris),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personAlex,m_projectOntoLogging),
        });
        assertSetEquals(m_cooperates_with.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personBoris,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personBoris),
        });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana);
        applyChange(new RemovePropertyInstance(propertyInstance));
        assertSetEquals(m_personLjiljana.getToPropertyInstances(),null);
        map=m_personLjiljana.getToPropertyValues();
        assertEquals(0,map.size());
        assertSetEquals(m_personAlex.getFromPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_address,m_personAlex,"FZI"),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personBoris),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personAlex,m_projectOntoLogging),
        });
        assertSetEquals(m_cooperates_with.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personBoris,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personBoris),
        });
    }
    public void testSetPropertyValue() throws Exception {
        assertSetEquals(m_cooperates_with.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personBoris,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personBoris),
        });
        PropertyInstance propertyInstance=m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana);
        applyChange(new SetPropertyInstanceValue(propertyInstance));
        assertSetEquals(m_personAlex.getFromPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_name,m_personAlex,"Alexander Maedche"),
            m_virtualOIModel.getPropertyInstance(m_address,m_personAlex,"FZI"),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
            m_virtualOIModel.getPropertyInstance(m_works_at,m_personAlex,m_projectOntoLogging),
        });
        assertSetEquals(m_personLjiljana.getToPropertyValues(m_cooperates_with),new Object[] { m_personAlex });
        assertSetEquals(m_personBoris.getToPropertyValues(m_cooperates_with),null);
        assertSetEquals(m_cooperates_with.getPropertyInstances(),new Object[] {
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personLjiljana,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personBoris,m_personAlex),
            m_virtualOIModel.getPropertyInstance(m_cooperates_with,m_personAlex,m_personLjiljana),
        });
    }
    public void testGetAllPropertyValues() throws Exception {
        assertSetEquals(m_personLjiljana.getAllFromPropertyValues(m_cooperates_with),new Object[] { m_personAlex });
        applyChange(new SetPropertyTransitive(m_cooperates_with,true));
        assertSetEquals(m_personLjiljana.getAllFromPropertyValues(m_cooperates_with),new Object[] { m_personAlex,m_personBoris });
    }
    public void testPropertyInstanceIsInOIModel() throws Exception {
        Property name=m_oimodel.getProperty("test:name");
        Instance personLjiljana=m_oimodel.getInstance("test:122");
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(name,personLjiljana,"Ljiljana 2");
        assertTrue(!propertyInstance.isInOIModel());
        VirtualPropertyInstance virtualPropertyInstance=m_virtualOIModel.getPropertyInstance(propertyInstance);
        assertTrue(!virtualPropertyInstance.isInOIModel());
        applyChange(new AddPropertyInstance(virtualPropertyInstance));
        assertTrue(!propertyInstance.isInOIModel());
        assertTrue(virtualPropertyInstance.isInOIModel());
    }
    public void testPropertyInstanceInclusion1() throws Exception {
        Property name=m_oimodel.getProperty("test:name");
        Instance personLjiljana=m_oimodel.getInstance("test:122");
        Object targetValue="Ljiljana 2";
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(name,personLjiljana,targetValue);
        assertTrue(!propertyInstance.isInOIModel());
        assertNull(propertyInstance.getSourceOIModel());
        VirtualPropertyInstance virtualPropertyInstance=m_virtualOIModel.getPropertyInstance(propertyInstance);
        assertTrue(!virtualPropertyInstance.isInOIModel());
        assertNull(virtualPropertyInstance.getSourceOIModel());
        assertNull(virtualPropertyInstance.getSourceOIModelOriginal());
        applyChange(new AddPropertyInstance(virtualPropertyInstance));
        assertTrue(!propertyInstance.isInOIModel());
        assertTrue(virtualPropertyInstance.isInOIModel());
        assertSame(m_virtualOIModel,virtualPropertyInstance.getSourceOIModel());
        assertSame(m_oimodel,virtualPropertyInstance.getSourceOIModelOriginal());
    }
}
