package edu.unika.aifb.kaon.virtualoimodel.test;

import java.util.*;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import edu.unika.aifb.kaon.virtualoimodel.*;

public class VirtualConceptTest extends VirtualTestXMLTest {

    public VirtualConceptTest(String name) {
        super(name);
    }
    public void testGetConcept() throws Exception {
        Concept concept=m_oimodel.getConcept("test:Person");
        assertEquals(concept,((VirtualConcept)m_virtualOIModel.getConcept("test:Person")).getConcept());
        assertSame(concept,m_person.getConcept());
    }
    public void testGetSubConcept() throws Exception {
        assertSetEquals(m_person.getSubConcepts(),new Object[] { m_employee,m_student });
        assertSetEquals(m_phdStudent.getSubConcepts(),null);
        assertSetEquals(m_employee.getSubConcepts(),new Object[] { m_phdStudent });
    }
    public void testGetSuperConcept() throws Exception {
        assertSetEquals(m_person.getSuperConcepts(),new Object[] { m_root });
        assertSetEquals(m_phdStudent.getSuperConcepts(),new Object[] { m_employee,m_student });
        assertSetEquals(m_employee.getSuperConcepts(),new Object[] { m_person });
    }
    public void testGetAllSubConcept() throws Exception {
        assertSetEquals(m_person.getAllSubConcepts(),new Object[] { m_employee,m_student,m_hiwi,m_phdStudent });
        assertSetEquals(m_root.getAllSubConcepts(),new Object[] { m_person,m_employee,m_student,m_hiwi,m_phdStudent,m_project,m_institution });
        assertSetEquals(m_phdStudent.getAllSubConcepts(),null);
    }
    public void testGetAllSuperConcept() throws Exception {
        assertSetEquals(m_phdStudent.getAllSuperConcepts(),new Object[] { m_root,m_employee,m_student,m_person });
        assertSetEquals(m_person.getAllSuperConcepts(),new Object[] { m_root });
        assertSetEquals(m_root.getAllSuperConcepts(),null);
    }
    public void testIsInOIModel() throws Exception {
        assertTrue(m_person.isInOIModel());
        assertTrue(!m_oimodel.getConcept("test:non-existent").isInOIModel());
        assertTrue(!m_virtualOIModel.getConcept("test:non-existent").isInOIModel());
    }
    public void testIsSubConcept() throws Exception {
        assertTrue(m_employee.isSubConceptOf(m_person));
        assertTrue(m_phdStudent.isSubConceptOf(m_person));
        assertTrue(m_phdStudent.isSubConceptOf(m_employee));
        assertTrue(m_phdStudent.isSubConceptOf(m_root));
    }
    public void testIsSuperConcept() throws Exception {
        assertTrue(m_phdStudent.isSubConceptOf(m_person));
        assertTrue(m_phdStudent.getAllSuperConcepts().contains(m_person));
        assertTrue(m_person.getAllSubConcepts().contains(m_phdStudent));
        assertTrue(!m_phdStudent.getSuperConcepts().contains(m_person));
        assertTrue(!m_person.getSubConcepts().contains(m_phdStudent));
    }
    public void testIsDirectSub() throws Exception {
        assertTrue(m_employee.isDirectSubConceptOf(m_person));
        assertTrue(!m_phdStudent.isDirectSubConceptOf(m_person));
        assertTrue(!m_person.isDirectSubConceptOf(m_employee));
    }
    public void testGetURI() throws Exception {
        assertEquals("test:Person",m_person.getURI());
    }
    public void testGetOIModel() throws Exception {
        assertSame(m_virtualOIModel,m_person.getOIModel());
    }
    public void testPropertiesFrom() throws Exception {
        assertSetEquals(m_person.getPropertiesFromConcept(),new Object[] { m_address,m_cooperates_with,m_name,m_works_at });
        assertSetEquals(m_project.getPropertiesFromConcept(),new Object[] { m_hasProject });
        assertSetEquals(m_hiwi.getPropertiesFromConcept(),null);
    }
    public void testAllPropertiesFrom() throws Exception {
        assertSetEquals(m_phdStudent.getAllPropertiesFromConcept(),new Object[] { m_address,m_cooperates_with,m_name,m_works_at,m_student_works_at,m_phdStudent_works_at });
        assertSetEquals(m_project.getAllPropertiesFromConcept(),new Object[] { m_hasProject });
    }
    public void testPropertiesTo() throws Exception {
        assertSetEquals(m_project.getPropertiesToConcept(),new Object[] { m_works_at,m_student_works_at,m_phdStudent_works_at,m_hasProject });
        assertSetEquals(m_person.getPropertiesToConcept(),new Object[] { m_cooperates_with });
        assertSetEquals(m_phdStudent.getPropertiesToConcept(),null);
    }
    public void testAllPropertiesTo() throws Exception {
        assertSetEquals(m_person.getAllPropertiesToConcept(),new Object[] { m_cooperates_with });
        assertSetEquals(m_phdStudent.getAllPropertiesToConcept(),new Object[] { m_cooperates_with });
    }
    public void testAddConcept() throws Exception {
        VirtualConcept failedProject=(VirtualConcept)m_virtualOIModel.getConcept("test:failed_project");
        assertTrue(!failedProject.isInOIModel());
        applyChanges(new ChangeEvent[] { new AddEntity(failedProject),new AddSubConcept(m_project,failedProject) });
        assertTrue(failedProject.isInOIModel());
        assertSetEquals(m_project.getSubConcepts(),new Object[] { failedProject });
        assertSetEquals(failedProject.getSuperConcepts(),new Object[] { m_project });
        assertTrue(!m_oimodel.getConcept("test:failed_project").isInOIModel());
    }
    public void testRemoveConceptNoTestFirst() throws Exception {
        applyChanges(new ChangeEvent[] { new RemoveSubConcept(m_student,m_hiwi),new RemoveEntity(m_hiwi) });
        assertSetEquals(m_student.getSubConcepts(),new Object[] { m_phdStudent });
        assertTrue(!m_hiwi.isInOIModel());
        assertTrue(m_oimodel.getConcept("test:HiWi").isInOIModel());
    }
    public void testRemoveConceptTestFirst() throws Exception {
        assertSetEquals(m_student.getSubConcepts(),new Object[] { m_hiwi,m_phdStudent });
        assertTrue(m_hiwi.isInOIModel());
        testRemoveConceptNoTestFirst();
    }
    public void testSpanningInstance() throws Exception {
        VirtualConcept failedProject=(VirtualConcept)m_virtualOIModel.getConcept("test:failed_project");
        VirtualInstance failedProjectInstance=(VirtualInstance)failedProject.getSpanningInstance();
        assertTrue(!failedProject.isInOIModel());
        assertTrue(!failedProjectInstance.isInOIModel());
        applyChanges(new ChangeEvent[] { new AddEntity(failedProject),new AddSubConcept(m_project,failedProject) });
        assertTrue(failedProject.isInOIModel());
        assertTrue(failedProjectInstance.isInOIModel());
    }
    public void testInclusion1() throws Exception {
        assertSame(m_virtualOIModel,m_person.getOIModel());
        assertSame(m_virtualOIModel,m_person.getSourceOIModel());
        assertSame(m_oimodel,m_person.getConcept().getOIModel());
        assertSame(m_oimodel,m_person.getSourceOIModelOriginal());
        VirtualConcept outerPerson=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Person");
        assertSame(m_virtualOuterOIModel,outerPerson.getOIModel());
        assertSame(m_virtualOuterOIModel,outerPerson.getSourceOIModel());
        assertSame(m_outerOIModel,outerPerson.getConcept().getOIModel());
        assertSame(m_oimodel,outerPerson.getSourceOIModelOriginal());
    }
    public void testInclusion2() throws Exception {
        assertSame(m_virtualOIModel,m_employee.getSuperSubConceptOIModel(m_person));
        assertSame(m_oimodel,m_employee.getSuperSubConceptOIModelOriginal(m_person));
        VirtualConcept outerPerson=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Person");
        VirtualConcept outerEmployee=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Employee");
        assertSame(m_virtualOuterOIModel,outerEmployee.getSuperSubConceptOIModel(outerPerson));
        assertSame(m_oimodel,outerEmployee.getSuperSubConceptOIModelOriginal(outerPerson));
    }
    public void testInclusion3() throws Exception {
        m_virtualOIModel.applyChanges(Collections.singletonList(new RemoveSubConcept(m_person,m_employee)));
        assertNull(m_employee.getSuperSubConceptOIModel(m_person));
        assertNull(m_employee.getSuperSubConceptOIModelOriginal(m_person));
        VirtualConcept outerPerson=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Person");
        VirtualConcept outerEmployee=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Employee");
        m_virtualOuterOIModel.applyChanges(Collections.singletonList(new RemoveSubConcept(outerPerson,outerEmployee)));
        assertNull(outerEmployee.getSuperSubConceptOIModel(outerPerson));
        assertNull(outerEmployee.getSuperSubConceptOIModelOriginal(outerPerson));
    }
    public void testInclusion4() throws Exception {
        assertSame(m_virtualOIModel,m_employee.getSuperSubConceptOIModel(m_person));
        assertSame(m_oimodel,m_employee.getSuperSubConceptOIModelOriginal(m_person));
        m_virtualOIModel.applyChanges(Collections.singletonList(new RemoveSubConcept(m_person,m_employee)));
        assertNull(m_employee.getSuperSubConceptOIModel(m_person));
        assertNull(m_employee.getSuperSubConceptOIModelOriginal(m_person));
        VirtualConcept outerPerson=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Person");
        VirtualConcept outerEmployee=(VirtualConcept)m_virtualOuterOIModel.getConcept("test:Employee");
        assertSame(m_virtualOuterOIModel,outerEmployee.getSuperSubConceptOIModel(outerPerson));
        assertSame(m_oimodel,outerEmployee.getSuperSubConceptOIModelOriginal(outerPerson));
        m_virtualOuterOIModel.applyChanges(Collections.singletonList(new RemoveSubConcept(outerPerson,outerEmployee)));
        assertNull(outerEmployee.getSuperSubConceptOIModel(outerPerson));
        assertNull(outerEmployee.getSuperSubConceptOIModelOriginal(outerPerson));
    }
}
