package edu.unika.aifb.kaon.evolutionlog.test;

import junit.framework.TestCase;
import java.util.Set;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.KAONVocabularyAdaptor;
import edu.unika.aifb.kaon.api.KAONException;

import edu.unika.aifb.kaon.apionrdf.OIModelImpl;
import edu.unika.aifb.kaon.apionrdf.*;

import edu.unika.aifb.kaon.defaultevolution.*;
import edu.unika.aifb.kaon.evolutionlog.*;

public class EvolutionLogTestListOfChanges extends EvolutionLogBaseTest {

    public EvolutionLogTestListOfChanges(String name) throws Exception {
        super(name);
    }
    public void testCauseOfChange() throws Exception {
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Person");
        applyChanges2(new ChangeEvent[] { new RemoveEntity(concept)});

        Concept eventRemoveEntity = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemoveEntity");
        Property property = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");

        Instance sourceChange = null;
        Set set  = eventRemoveEntity.getInstances();
        assertTrue(set.size() >= 1);
        int countCaused = 0;
        boolean found=false;
        Iterator iter = set.iterator();
        while ( (iter.hasNext()) && !(found)) {
            Instance instance = (Instance) iter.next();
            String value=(String) instance.getFromPropertyValue(property);
            if (value!=null) {
                if ( value.equals(concept.getURI())) {
                    found=true;
                    sourceChange = instance;
                    countCaused = instance.getFromPropertyValues(propertyCausesChange).size();
                }
            }
        }

        assertNotNull(sourceChange.getFromPropertyValue(propertyCausesChange));
        assertTrue(countCaused > 0);

        Instance logInstance = (Instance) logConcept.getInstances().iterator().next();
        Instance lastChange = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        assertEquals(sourceChange,lastChange);
    }
    public void testFirstChangeInAGroup() throws Exception {
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Person");
        applyChanges2(new ChangeEvent[] { new RemoveEntity(concept)});

        Set instances=evolutionLogModelInstance.getInstances();
        assertTrue(instances.size() >= 1);
        boolean found=false;
        Iterator iter = instances.iterator();
        while ( (iter.hasNext()) && !(found)) {
            Instance instance = (Instance) iter.next();
            String value=(String) instance.getFromPropertyValue(propertyFirstChangeInAGroup);
            if (value!=null) {
                if ( value.equals("true")) {
                    found=true;
                    assertEquals(instance.getFromPropertyValues(propertyPreviousChange).size(),0);
                }
            }
        }
    }
    public void testPreviousChange() throws Exception {
        Concept conceptHiWi = domainOIModel.getConcept(DOMAINNS + "HiWi");
        Concept conceptStudent = domainOIModel.getConcept(DOMAINNS + "Student");
        Concept conceptPersonXXX = domainOIModel.getConcept(DOMAINNS + "PersonXXX");

        applyChanges2(new ChangeEvent[] { new RemoveEntity(conceptHiWi), new RemoveEntity(conceptStudent), new AddEntity(conceptPersonXXX)});

        Concept eventAddEntity = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddEntity");
        Concept eventRemoveEntity = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemoveEntity");

        Set set  = eventAddEntity.getInstances();
        assertEquals(1, set.size());
        Iterator iter = set.iterator();
        Instance instanceAddEntity = (Instance) iter.next();
        assertNotNull(instanceAddEntity.getFromPropertyValue(propertyPreviousChange));
        assertNull(instanceAddEntity.getFromPropertyValue(propertyFirstChangeInAGroup));

        Instance instancePreviousInstance = (Instance) instanceAddEntity.getFromPropertyValue(propertyPreviousChange);
        assertTrue(eventRemoveEntity.getInstances().contains(instancePreviousInstance));
        assertNotNull(instancePreviousInstance.getFromPropertyValue(propertyPreviousChange));
        assertNull(instancePreviousInstance.getFromPropertyValue(propertyFirstChangeInAGroup));

        boolean found=false;
        while(!found) {
            Instance instance=(Instance) instancePreviousInstance.getFromPropertyValue(propertyPreviousChange);
            String value=(String) instance.getFromPropertyValue(propertyFirstChangeInAGroup);
            if (value!=null) {
                found=true;
                assertEquals(value,"true");
                assertNull(instance.getFromPropertyValue(propertyPreviousChange));
            }
            else
               assertNotNull(instance.getFromPropertyValue(propertyPreviousChange));
            instancePreviousInstance=instance;
        }
    }
    public void testChangeLog() throws Exception {
        Concept conceptHiWi = domainOIModel.getConcept(DOMAINNS + "HiWi");
        Concept conceptStudent = domainOIModel.getConcept(DOMAINNS + "Student");
        Concept conceptPersonXXX = domainOIModel.getConcept(DOMAINNS + "PersonXXX");

        applyChanges2(new ChangeEvent[] { new RemoveEntity(conceptHiWi),new RemoveEntity(conceptStudent) });

        Set setLogInstance = logConcept.getInstances();
        assertEquals(1, setLogInstance.size());
        Instance logInstance = (Instance) setLogInstance.iterator().next();
        Instance previousChange1 = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        assertNotNull(previousChange1);

        applyChanges2(new ChangeEvent[] { new AddEntity(conceptPersonXXX) });
        setLogInstance = logConcept.getInstances();
        assertEquals(1, setLogInstance.size());
        logInstance = (Instance) setLogInstance.iterator().next();
        Instance previousChange2 = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        assertNotNull(previousChange2);
        assertEquals((Instance)previousChange2.getFromPropertyValue(propertyPreviousChange),previousChange1);
    }
    public void testChangeGroupDependency() throws Exception {
        Concept conceptHiWi = domainOIModel.getConcept(DOMAINNS + "HiWi");
        Concept conceptStudent = domainOIModel.getConcept(DOMAINNS + "Student");

        //first
        applyChanges2(new ChangeEvent[] { new RemoveEntity(conceptHiWi) });

        Instance logInstance = (Instance) logConcept.getInstances().iterator().next();
        Instance firstInstance = (Instance) logInstance.getFromPropertyValue(propertyLastChange);

        //second
        applyChanges2(new ChangeEvent[] { new RemoveEntity(conceptStudent) });
        Instance secondInstance = (Instance) logInstance.getFromPropertyValue(propertyLastChange);

        assertTrue(!firstInstance.equals(secondInstance));
        boolean found = false;
        while(!found) {
            Instance previousInstance = (Instance)secondInstance.getFromPropertyValue(propertyPreviousChange);
            String value = (String) previousInstance.getFromPropertyValue(propertyFirstChangeInAGroup);
            if (value!=null) {
                if (value.equals("true")) {
                    found = true;
                    Instance instance=(Instance)previousInstance.getFromPropertyValue(propertyPreviousChange);
                    assertTrue(instance.equals(firstInstance));
                }
            }
            secondInstance=previousInstance;
        }
    }
    public void testChangeUndo1() throws Exception {
        Concept conceptHiWi = domainOIModel.getConcept(DOMAINNS + "HiWi");
        assertTrue(domainOIModel.getConcepts().contains(conceptHiWi));

        //change
        applyChanges2(new ChangeEvent[] { new RemoveEntity(conceptHiWi) });
        Instance logInstance = (Instance) logConcept.getInstances().iterator().next();
        Instance changeInstance = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        Instance redoInstance = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);

        assertTrue(!domainOIModel.getConcepts().contains(conceptHiWi));
        assertNotNull(changeInstance);
        assertNull(redoInstance);

        //undo
        List changeList = evolutionLog.readUndoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);
        assertTrue(domainOIModel.getConcepts().contains(conceptHiWi));
        redoInstance = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertNotNull(redoInstance);
        Instance lastChange = (Instance) redoInstance.getFromPropertyValue(propertyListItemChange);
        assertEquals(lastChange,changeInstance);

        changeInstance = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        assertNull(changeInstance);

        try{
            changeList = evolutionLog.readUndoChanges();
        }
        catch(KAONException e)
        {
            assertEquals("There is no previous change",e.getMessage());
        }
    }
    public void testChangeUndo2() throws Exception {
        Concept conceptX = domainOIModel.getConcept(DOMAINNS + "XXX");
        Concept conceptY = domainOIModel.getConcept(DOMAINNS + "YYY");
        Concept conceptZ = domainOIModel.getConcept(DOMAINNS + "ZZZ");

        //change
        applyChanges2(new ChangeEvent[] { new AddEntity(conceptX),  new AddEntity(conceptY) });
        Instance logInstance = (Instance) logConcept.getInstances().iterator().next();
        Instance changeInstance1 = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        Instance redoInstance1 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertNull(redoInstance1);

        applyChanges2(new ChangeEvent[] { new AddEntity(conceptZ) });
        Instance changeInstance2 = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        Instance redoInstance2 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertNull(redoInstance2);

        //undo
        List changeList = evolutionLog.readUndoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);

        Instance redoInstance3 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        Instance redoChangeInstance = (Instance) redoInstance3.getFromPropertyValue(propertyListItemChange);
        assertNotNull(redoInstance3);
        assertEquals(redoChangeInstance, changeInstance2);

        //undo
        changeList = evolutionLog.readUndoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);

        Instance redoInstance4 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        redoChangeInstance = (Instance) redoInstance4.getFromPropertyValue(propertyListItemChange);
        assertNotNull(redoInstance4);
        assertEquals(redoChangeInstance, changeInstance1);
    }

    public void testChangeRedo() throws Exception {
        Concept conceptX = domainOIModel.getConcept(DOMAINNS + "XXX");
        Concept conceptY = domainOIModel.getConcept(DOMAINNS + "YYY");
        Concept conceptZ = domainOIModel.getConcept(DOMAINNS + "ZZZ");

        //change
        applyChanges2(new ChangeEvent[] { new AddEntity(conceptX)});
        Instance logInstance = (Instance) logConcept.getInstances().iterator().next();
        Instance changeInstance1 = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        Instance redoInstance1 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertNull(redoInstance1);

        applyChanges2(new ChangeEvent[] { new AddEntity(conceptY) });
        Instance changeInstance2 = (Instance) logInstance.getFromPropertyValue(propertyLastChange);
        Instance redoInstance2 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertNull(redoInstance2);

        //undo
        List changeList = evolutionLog.readUndoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);

        Instance redoInstance3 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        Instance redoChangeInstance3 = (Instance) redoInstance3.getFromPropertyValue(propertyListItemChange);
        assertNotNull(redoInstance3);
        assertEquals(redoChangeInstance3, changeInstance2);

        //undo
        changeList = evolutionLog.readUndoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);

        Instance redoInstance4 = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        Instance redoChangeInstance4 = (Instance) redoInstance4.getFromPropertyValue(propertyListItemChange);
        assertNotNull(redoInstance4);
        assertEquals(redoChangeInstance4, changeInstance1);

        //redo
        changeList = evolutionLog.readRedoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);

        Instance instance = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertEquals(instance, redoInstance3);

        //redo
        changeList = evolutionLog.readRedoChanges();
        assertNotNull(changeList);
        applyChanges (changeList);

        instance = (Instance) logInstance.getFromPropertyValue(propertyRedoChange);
        assertNull(instance);
    }
    public void testReadChanges() throws Exception {
        Concept conceptX = domainOIModel.getConcept(DOMAINNS + "XXX");
        Concept conceptY = domainOIModel.getConcept(DOMAINNS + "YYY");
        Concept conceptZ = domainOIModel.getConcept(DOMAINNS + "ZZZ");
        Concept concept = domainOIModel.getConcept(DOMAINNS + "HiWi");

        //change
        applyChanges2(new ChangeEvent[] { new AddEntity(conceptX),  new AddEntity(conceptY) });
        applyChanges2(new ChangeEvent[] { new RemoveEntity(concept)});
        applyChanges2(new ChangeEvent[] { new AddEntity(conceptZ) });

        List changes=evolutionLog.readChanges(0);
        assertTrue(changes.size()>0);

        ChangeEvent event=(ChangeEvent)changes.get(0);
        assertTrue(event.getOIModel().equals(domainOIModel));
    }
}
