package edu.unika.aifb.kaon.evolutionlog.test;

import junit.framework.TestCase;
import java.util.Set;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.KAONVocabularyAdaptor;
import edu.unika.aifb.kaon.api.KAONException;

import edu.unika.aifb.kaon.apionrdf.OIModelImpl;
import edu.unika.aifb.kaon.apionrdf.*;

import edu.unika.aifb.kaon.defaultevolution.*;
import edu.unika.aifb.kaon.evolutionlog.*;

public class EvolutionLogTestChanges extends EvolutionLogBaseTest {

    public EvolutionLogTestChanges(String name) throws Exception {
        super(name);
    }
    public void testAddEntity() throws Exception {
        Concept concept = domainOIModel.getConcept("NewConcept");
        Property property = domainOIModel.getProperty("NewProperty");
        Instance instance = domainOIModel.getInstance("NewInstance");


        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddEntity");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty3 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceInstance");
        Property eventProperty = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceEntity");

        assertNotInModel(eventConcept,eventProperty,concept.getURI());
        assertNotInModel(eventConcept,eventProperty1,concept.getURI());
        assertNotInModel(eventConcept,eventProperty2,property.getURI());
        assertNotInModel(eventConcept,eventProperty3,instance.getURI());

        applyChanges1(new ChangeEvent[] { new AddEntity(concept),new AddEntity(property), new AddEntity(instance) });

        assertNotInModel(eventConcept,eventProperty,concept.getURI());
        assertInModel(eventConcept,eventProperty1,concept.getURI());
        assertInModel(eventConcept,eventProperty2,property.getURI());
        assertInModel(eventConcept,eventProperty3,instance.getURI());
    }
    public void testRemoveEntity() throws Exception {
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Institution");
        Property property1 = domainOIModel.getProperty(DOMAINNS + "name");
        Property property2 = domainOIModel.getProperty(DOMAINNS + "cooperates_with");
        Instance instance = domainOIModel.getInstance(DOMAINNS + "142");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemoveEntity");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty3 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceInstance");
        Property eventProperty = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceEntity");

        assertNotInModel(eventConcept,eventProperty,concept.getURI());
        assertNotInModel(eventConcept,eventProperty1,concept.getURI());
        assertNotInModel(eventConcept,eventProperty2,property1.getURI());
        assertNotInModel(eventConcept,eventProperty2,property2.getURI());
        assertNotInModel(eventConcept,eventProperty3,instance.getURI());

        applyChanges1(new ChangeEvent[] { new RemoveEntity(concept),new RemoveEntity(property1), new RemoveEntity(property2), new RemoveEntity(instance) });

        assertNotInModel(eventConcept,eventProperty,concept.getURI());
        assertInModel(eventConcept,eventProperty1,concept.getURI());
        assertInModel(eventConcept,eventProperty2,property1.getURI());
        assertInModel(eventConcept,eventProperty2,property2.getURI());
        assertInModel(eventConcept,eventProperty3,instance.getURI());
    }
    public void testAddSubConcept() throws Exception {
        Concept conceptSuper = domainOIModel.getConcept(DOMAINNS + "Project");
        Concept conceptSub = domainOIModel.getConcept(DOMAINNS + "ResearchProject");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddSubConcept");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSuperConcept");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSubConcept");

        applyChanges1(new ChangeEvent[] { new AddEntity(conceptSub),new AddSubConcept(conceptSuper, conceptSub) });

        assertTwoInModel(eventConcept,eventProperty1,conceptSuper.getURI(),eventProperty2,conceptSub.getURI());
    }
    public void testRemoveSubConcept() throws Exception {
        Concept conceptSuper = domainOIModel.getConcept(DOMAINNS + "Person");
        Concept conceptSub = domainOIModel.getConcept(DOMAINNS + "Employee");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemoveSubConcept");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSuperConcept");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSubConcept");

        applyChanges1(new ChangeEvent[] { new RemoveSubConcept(conceptSuper, conceptSub) });

        assertTwoInModel(eventConcept,eventProperty1,conceptSuper.getURI(),eventProperty2,conceptSub.getURI());
    }
    public void testAddPropertyDomain()throws Exception {
        Property property = domainOIModel.getProperty(DOMAINNS + "works_at");
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Project");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddPropertyDomain");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");

        applyChanges1(new ChangeEvent[] {new AddPropertyDomain(property, concept) });

        assertTwoInModel(eventConcept,eventProperty1,property.getURI(), eventProperty2,concept.getURI());
    }
    public void testRemovePropertyDomain()throws Exception {
        Property property = domainOIModel.getProperty(DOMAINNS + "works_at");
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Person");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemovePropertyDomain");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");

        applyChanges1(new ChangeEvent[] {new RemovePropertyDomain(property, concept) });

        assertTwoInModel(eventConcept,eventProperty1,property.getURI(), eventProperty2,concept.getURI());
    }
    public void testSetPropertyIsAttribute()throws Exception {
        Property property = domainOIModel.getProperty(DOMAINNS + "PhDstudent_works_at");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "SetPropertyIsAttribute");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_value");

        applyChanges1(new ChangeEvent[] { new SetPropertyIsAttribute(property, true) });

        assertTwoInModel(eventConcept,eventProperty1,property.getURI(),eventProperty2,"true");

        applyChanges1(new ChangeEvent[] { new SetPropertyIsAttribute(property, false) });

        assertTwoInModel(eventConcept,eventProperty1,property.getURI(),eventProperty2,"false");
    }
    public void testAddRemoveSubProperty() throws Exception {
        Property propertySuper = domainOIModel.getProperty(DOMAINNS + "name");
        Property propertySub = domainOIModel.getProperty(DOMAINNS + "project_name");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddSubProperty");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSuperProperty");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSubProperty");

        applyChanges1(new ChangeEvent[] { new AddEntity(propertySub), new AddSubProperty(propertySuper, propertySub)});
        assertTwoInModel(eventConcept,eventProperty1,propertySuper.getURI(),eventProperty2,propertySub.getURI());

        eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemoveSubProperty");
        applyChanges1(new ChangeEvent[] { new RemoveSubProperty(propertySuper, propertySub)});
        assertTwoInModel(eventConcept,eventProperty1,propertySuper.getURI(),eventProperty2,propertySub.getURI());
    }
    public void testAddInstanceOf() throws Exception {
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Person");
        Instance instance = domainOIModel.getInstance("PersonXXX");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddInstanceOf");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceInstance");

        applyChanges1(new ChangeEvent[] { new AddEntity(instance), new AddInstanceOf(concept, instance)});

        assertTwoInModel(eventConcept,eventProperty1,concept.getURI(),eventProperty2,instance.getURI());
    }
    public void testRemoveInstanceOf() throws Exception {
        Concept concept = domainOIModel.getConcept(DOMAINNS + "Person");
        Instance instance = domainOIModel.getInstance(DOMAINNS + "122");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemoveInstanceOf");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceConcept");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceInstance");

        applyChanges1(new ChangeEvent[] { new RemoveInstanceOf(concept, instance)});

        assertTwoInModel(eventConcept,eventProperty1,concept.getURI(),eventProperty2,instance.getURI());
    }
    public void testAddPropertyInstance() throws Exception {
        Instance instanceSource = domainOIModel.getInstance(DOMAINNS + "122");
        Property property = domainOIModel.getProperty(DOMAINNS + "name");
        String target = "newName";

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "AddPropertyInstance");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSourceInstance");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty3 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceTargetObject");

        applyChanges1(new ChangeEvent[] { new AddPropertyInstance(property, instanceSource, target)});

        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty2,property.getURI());
        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty3,target);
        assertTwoInModel(eventConcept,eventProperty2,property.getURI(),eventProperty3,target);
    }
    public void testRemovePropertyInstance() throws Exception {
        Instance instanceSource = domainOIModel.getInstance(DOMAINNS + "127");
        Property property = domainOIModel.getProperty(DOMAINNS + "works_at");
        Instance instanceTarget = domainOIModel.getInstance(DOMAINNS + "137");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "RemovePropertyInstance");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSourceInstance");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty3 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceTargetInstance");

        applyChanges1(new ChangeEvent[] { new RemovePropertyInstance(property, instanceSource, instanceTarget)});

        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty2,property.getURI());
        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty3,instanceTarget.getURI());
        assertTwoInModel(eventConcept,eventProperty2,property.getURI(),eventProperty3,instanceTarget.getURI());
    }
    public void testSetPropertyInstanceValue() throws Exception {
        Instance instanceSource = domainOIModel.getInstance(DOMAINNS + "122");
        Property property = domainOIModel.getProperty(DOMAINNS + "address");
        String target = "newAddress";

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "SetPropertyInstanceValue");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSourceInstance");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty3 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceTargetObject");

        applyChanges1(new ChangeEvent[] { new SetPropertyInstanceValue(property, instanceSource, target)});

        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty2,property.getURI());
        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty3,target);
        assertTwoInModel(eventConcept,eventProperty2,property.getURI(),eventProperty3,target);
    }
    public void testSetInverseProperties() throws Exception {
        Property property1 = domainOIModel.getProperty(DOMAINNS + "works_at");
        Property property2 = domainOIModel.getProperty(DOMAINNS + "has_participant");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "SetInverseProperties");
        Property eventProperty = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");

        applyChanges1(new ChangeEvent[] { new SetInverseProperties(property1, property2)});

        Set set = eventConcept.getInstances();
        assertNotNull(set);
        assertEquals(set.size(),1);
        assertInModel(eventConcept,eventProperty,property1.getURI());
        assertInModel(eventConcept,eventProperty,property2.getURI());

        assertTwoInModel(eventConcept,eventProperty,property1.getURI(),eventProperty,property2.getURI());
    }
    public void testSetNoInverseProperties() throws Exception {
        Property property = domainOIModel.getProperty(DOMAINNS + "111");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "SetNoInverseProperty");
        Property eventProperty = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");

        assertTrue(domainOIModel.getProperties().contains(property));
        assertNotNull(property.getInverseProperty());

        applyChanges1(new ChangeEvent[] { new SetNoInverseProperties(property,property.getInverseProperty())});

        assertInModel(eventConcept,eventProperty,property.getURI());
    }
    public void testSetPropertySymmetric() throws Exception {
        Property property = domainOIModel.getProperty(DOMAINNS + "cooperates_with");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "SetPropertySymmetric");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_value");

        applyChanges1(new ChangeEvent[] { new SetPropertySymmetric(property, true)});

        assertTwoInModel(eventConcept,eventProperty1,property.getURI(),eventProperty2,"true");

        applyChanges1(new ChangeEvent[] { new SetPropertySymmetric(property, false)});
        assertTwoInModel(eventConcept,eventProperty1,property.getURI(),eventProperty2,"false");
    }
    public void testSetPropertyTransitive() throws Exception {
        Property property = domainOIModel.getProperty(DOMAINNS + "cooperates_with");

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "SetPropertyTransitive");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_value");

        applyChanges1(new ChangeEvent[] { new SetPropertyTransitive(property, true)});
        assertTwoInModel(eventConcept,eventProperty1,property.getURI(),eventProperty2,"true");

        applyChanges1(new ChangeEvent[] { new SetPropertyTransitive(property, false)});
        assertTwoInModel(eventConcept,eventProperty1,property.getURI(),eventProperty2,"false");
    }
    public void testChangePropertyInstanceValue() throws Exception {
        Instance instanceSource = domainOIModel.getInstance(DOMAINNS + "122");
        Property property = domainOIModel.getProperty(DOMAINNS + "address");
        String targetOld = "oldAddress";
        String targetNew = "changedAddress";

        Concept eventConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "ChangePropertyInstanceValue");
        Property eventProperty1 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceSourceInstance");
        Property eventProperty2 = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_referenceProperty");
        Property eventPropertyOld = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_oldReferenceTargetObject");
        Property eventPropertyNew = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_newReferenceTargetObject");

        applyChanges1(new ChangeEvent[] { new SetPropertyInstanceValue(property, instanceSource, targetOld)});

        applyChanges1(new ChangeEvent[] { new ChangePropertyInstanceValue(property, instanceSource, targetOld,targetNew )});

        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventProperty2,property.getURI());
        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventPropertyOld,targetOld);
        assertTwoInModel(eventConcept,eventProperty1,instanceSource.getURI(),eventPropertyNew,targetNew);
        assertTwoInModel(eventConcept,eventProperty2,property.getURI(),eventPropertyNew,targetNew);
    }
}
