package edu.unika.aifb.kaon.evolutionlog.test;

import junit.framework.TestCase;
import java.util.Set;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collections;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.*;

import edu.unika.aifb.kaon.defaultevolution.*;
import edu.unika.aifb.kaon.evolutionlog.*;

public class EvolutionLogBaseTest extends TestCase {
    protected static String DOMAINNS="test:";

    protected EvolutionStrategy domainEvolutionStrategy;
    protected KAONConnectionEvolutionLogs kaonConnectionEvolutionLogs;
    protected EvolutionLog evolutionLog;
    protected OIModel evolutionLogModelInstance;
    protected OIModel domainOIModel;

    protected Concept logConcept;
    protected Property propertyPreviousChange;
    protected Property propertyCausesChange;
    protected Property propertyFirstChangeInAGroup;
    protected Property propertyLastChange;
    protected Property propertyRedoChange;
    protected Property propertyListItemChange;

    public EvolutionLogBaseTest(String name) throws Exception {
        super(name);
    }
    protected void setUp() throws Exception {
        Map parameters=new HashMap();
        parameters.put(KAONManager.KAON_CONNECTION,"edu.unika.aifb.kaon.apionrdf.KAONConnectionImpl");
        KAONConnection connection=KAONManager.getKAONConnection(parameters);
        domainOIModel=connection.openOIModelPhysical(EvolutionLogBaseTest.class.getResource("res/test.xml").toString());
        domainOIModel.applyChanges(Collections.singletonList(new AddIncludedOIModel(connection.openOIModelLogical(KAONConnection.LEXICAL_OIMODEL_URI))));
        domainEvolutionStrategy=new EvolutionStrategyImpl(domainOIModel);
        kaonConnectionEvolutionLogs=new KAONConnectionEvolutionLogs();
        evolutionLogModelInstance=connection.createOIModel("file:/c:/tempEvolution.kaon","file:tempEvolution.kaon");
        evolutionLog=new OIModelEvolutionLog(kaonConnectionEvolutionLogs,domainOIModel,evolutionLogModelInstance);
    }

    public void testOIModel() throws Exception {
        assertNotNull(domainOIModel);
    }
    public void testEvolutionLog() throws Exception {
        assertNotNull(evolutionLog);
    }
    protected void assertInModel(Concept eventConcept, Property property, String URI) throws Exception {
        Set set = eventConcept.getInstances();
        Iterator iter = set.iterator();
        boolean found = false;
        while( ( iter.hasNext()) && !(found))
        {
            Instance eventInstance = (Instance) iter.next();
            Set setPropertyValues = eventInstance.getFromPropertyValues(property);
            Iterator iterPropertyValues = setPropertyValues.iterator();
            while ( (iterPropertyValues.hasNext()) && !(found) )
            {
                String target = (String)iterPropertyValues.next();
                if (URI.equals(target))
                    found = true;
            }
        }
        if (!found)
            fail("Model doesn't contain entity "+ URI);
    }

    protected void assertNotInModel(Concept eventConcept, Property property, String URI) throws KAONException {
        Set set = eventConcept.getInstances();
        Iterator iter = set.iterator();
        boolean found = false;
        while( ( iter.hasNext()) && !(found))
        {
            Instance eventInstance = (Instance) iter.next();
            Set setPropertyValues = eventInstance.getFromPropertyValues(property);
            Iterator iterPropertyValues = setPropertyValues.iterator();
            while ( (iterPropertyValues.hasNext()) && !(found) )
            {
                String target = (String)iterPropertyValues.next();
                if (URI.equals(target))
                    found = true;
            }
        }
        if (found)
            fail("Model contains entity "+ URI);
    }

    protected void assertTwoInModel(Concept eventConcept, Property property1, String object1, Property property2, String object2) throws KAONException {
        Set set = eventConcept.getInstances();
        Iterator iter = set.iterator();
        boolean found = false;
        while( ( iter.hasNext()) && !(found))
        {
            Instance eventInstance = (Instance) iter.next();
            Set setPropertyValues = eventInstance.getFromPropertyValues(property1);
            Iterator iterPropertyValues = setPropertyValues.iterator();
            while ( (iterPropertyValues.hasNext()) && !(found) )
            {
                String target1 = (String)iterPropertyValues.next();

                Set setPropertyValues2 = eventInstance.getFromPropertyValues(property2);
                Iterator iterPropertyValues2 = setPropertyValues2.iterator();
                while ( (iterPropertyValues2.hasNext()) && !(found) )
                {
                    String target2 = (String)iterPropertyValues2.next();
                    if ( (target1.equals(object1)) && (target2.equals(object2)))
                      found = true;
                }
            }
        }
        if (!found)
            fail("Model doesn't contain entities ");
    }
    protected void init() throws Exception {
        logConcept = evolutionLogModelInstance.getConcept(OIModelEvolutionLog.EVOLUTIONNS + "LOG");
        propertyPreviousChange = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "has_previousChange");
        propertyFirstChangeInAGroup = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "firstChangeInAGroup");
        propertyCausesChange = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "causesChange");
        propertyLastChange = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "lastChange");
        propertyRedoChange = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "redoListHead");
        propertyListItemChange = evolutionLogModelInstance.getProperty(OIModelEvolutionLog.EVOLUTIONNS + "listItemChange");
    }

    protected void applyChanges1(ChangeEvent[] events) throws Exception {
        List list=new LinkedList();
        for (int i=0;i<events.length;i++)
            list.add(events[i]);
        domainOIModel.applyChanges(list);
        evolutionLog.logChanges(list,EvolutionLog.LOG_NORMAL);
    }
    protected void applyChanges2(ChangeEvent[] events) throws Exception {
        List list=new LinkedList();
        for (int i=0;i<events.length;i++)
            list.add(events[i]);
        List neededChanges=domainEvolutionStrategy.computeRequestedChanges(list);
        domainOIModel.applyChanges(neededChanges);
        evolutionLog.logChanges(neededChanges,EvolutionLog.LOG_NORMAL);
        init();
    }
    protected void applyChanges(List changeList) throws Exception {
        Iterator iter =  changeList.iterator();
        while (iter.hasNext()) {
            ChangeEvent event = (ChangeEvent) iter.next();
            domainOIModel.applyChanges(Collections.singletonList(event));
        }
    }
}