package edu.unika.aifb.kaon.defaultevolution.test;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Abstract class for all tests based on text.xml file.
 */
public abstract class EvolutionStrategyTestXMLTest extends EvolutionStrategyBaseTest {
    protected static Model s_testModel;
    static {
        try {
            s_testModel=RDFManager.openModel(EvolutionStrategyTestXMLTest.class.getResource("res/test.xml").toString(),null);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_testModel=null;
        }
    }

    protected Concept m_root;
    protected Concept m_person;
    protected Concept m_student;
    protected Concept m_phdStudent;
    protected Concept m_hiwi;
    protected Concept m_employee;
    protected Concept m_project;
    protected Concept m_institution;
    protected Property m_name;
    protected Property m_address;
    protected Property m_cooperates_with;
    protected Property m_works_at;
    protected Property m_student_works_at;
    protected Property m_phdStudent_works_at;
    protected Property m_hasProject;
    protected Property m_type;
    protected Property m_explanation;
    protected Instance m_personLjiljana;
    protected Instance m_personBoris;
    protected Instance m_personAlex;
    protected Instance m_projectOntoLogging;
    protected Instance m_studentProject;
    protected Instance m_studentInstance;
    protected Instance m_phdStudentInstance;
    protected LexicalEntry m_student_label_en;
    protected LexicalEntry m_all_students_label_en;
    protected LexicalEntry m_ljiljana_label_en;
    protected LexicalEntry m_person_label_en;

    public EvolutionStrategyTestXMLTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        super.setUp();
        m_root=m_oimodel.getRootConcept();
        m_person=m_oimodel.getConcept("test:Person");
        m_student=m_oimodel.getConcept("test:Student");
        m_phdStudent=m_oimodel.getConcept("test:PhDStudent");
        m_hiwi=m_oimodel.getConcept("test:HiWi");
        m_employee=m_oimodel.getConcept("test:Employee");
        m_project=m_oimodel.getConcept("test:Project");
        m_institution=m_oimodel.getConcept("test:Institution");
        m_name=m_oimodel.getProperty("test:name");
        m_address=m_oimodel.getProperty("test:address");
        m_cooperates_with=m_oimodel.getProperty("test:cooperates_with");
        m_works_at=m_oimodel.getProperty("test:works_at");
        m_student_works_at=m_oimodel.getProperty("test:student_works_at");
        m_phdStudent_works_at=m_oimodel.getProperty("test:PhDstudent_works_at");
        m_hasProject=m_oimodel.getProperty("test:has_Project");
        m_type=m_oimodel.getProperty("test:type");
        m_explanation=m_oimodel.getProperty("test:explanation");
        m_personLjiljana=m_oimodel.getInstance("test:122");
        m_personBoris=m_oimodel.getInstance("test:127");
        m_personAlex=m_oimodel.getInstance("test:131");
        m_projectOntoLogging=m_oimodel.getInstance("test:137");
        m_studentProject=m_oimodel.getInstance("test:150");
        m_studentInstance=m_oimodel.getInstance("test:123456");
        m_phdStudentInstance=m_oimodel.getInstance("test:142");
        m_student_label_en=m_oimodel.getLexicalEntry("test:98");
        m_all_students_label_en=m_oimodel.getLexicalEntry("test:99");
        m_ljiljana_label_en=m_oimodel.getLexicalEntry("test:123");
        m_person_label_en=m_oimodel.getLexicalEntry("test:61");
    }
    protected Model getDefaultModel() {
        return s_testModel;
    }
}
