package edu.unika.aifb.kaon.defaultevolution.test;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.defaultevolution.*;

public class EvolutionStrategyPropertyTest extends EvolutionStrategyTestXMLTest {

    public EvolutionStrategyPropertyTest(String name) {
        super(name);
    }
    public void testAddProperty() throws Exception {
        Property property=m_oimodel.getProperty("test:newProperty");
        assertTrue(!m_oimodel.getProperties().contains(property));
        assertTrue(!property.isInOIModel());
        applyChange(new AddEntity(property));
        assertTrue(m_oimodel.getProperties().contains(property));
        assertTrue(property.isInOIModel());
    }
    public void testAddExistingProperty() throws Exception {
        assertTrue(m_oimodel.getProperties().contains(m_works_at));
        assertTrue(m_works_at.isInOIModel());
        try {
            applyChange(new AddEntity(m_works_at));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:works_at' is in OI model.",mustHappen.getMessage());
        }
        assertTrue(m_oimodel.getProperties().contains(m_works_at));
        assertTrue(m_works_at.isInOIModel());
    }
    public void testRemoveProperty() throws Exception {
        m_evolutionStrategy.setOrphanedProperties(EvolutionStrategyImpl.ORPHANED_PROPERTIES_LEAVE_ALONE);
        applyChange(new RemoveEntity(m_works_at));
        assertTrue(!m_oimodel.getProperties().contains(m_works_at));
        assertTrue(!m_works_at.isInOIModel());
        assertTrue(m_oimodel.getProperties().contains(m_student_works_at));
        assertTrue(m_student_works_at.isInOIModel());
        assertSetEquals(m_student_works_at.getAllSuperProperties(),null);
        assertTrue(!m_student_works_at.isDirectSubPropertyOf(m_works_at));
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personBoris.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personAlex.getFromPropertyValues(m_works_at),null);
    }
    public void testAddRemoveProperty() throws Exception {
        applyChanges(new ChangeEvent[] { new RemoveEntity(m_works_at),new AddEntity(m_works_at) });
        assertTrue(m_oimodel.getProperties().contains(m_works_at));
        assertTrue(m_works_at.isInOIModel());
        assertSetEquals(m_student_works_at.getAllSuperProperties(),null);
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personBoris.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personAlex.getFromPropertyValues(m_works_at),null);
    }
    public void testAddRemoveNewConcept() throws Exception {
        Property property=m_oimodel.getProperty("test:newProperty");
        assertTrue(!property.isInOIModel());
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(property),new RemoveEntity(property),new AddEntity(property),new AddEntity(property) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:newProperty' is in OI model.",mustHappen.getMessage());
        }
        assertTrue(!property.isInOIModel());
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(property),new RemoveEntity(property),new RemoveEntity(property) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:newProperty' is not in OI model.",mustHappen.getMessage());
        }
    }
    public void testAddRemoveExistingConcept() throws Exception {
        try {
            applyChanges(new ChangeEvent[] { new RemoveEntity(m_works_at),new AddEntity(m_works_at),new RemoveEntity(m_works_at),new AddEntity(m_works_at),new AddEntity(m_works_at) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:works_at' is in OI model.",mustHappen.getMessage());
        }
        try {
            applyChanges(new ChangeEvent[] { new RemoveEntity(m_works_at),new AddEntity(m_works_at),new RemoveEntity(m_works_at),new RemoveEntity(m_works_at),new AddEntity(m_works_at),new AddEntity(m_works_at) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:works_at' is not in OI model.",mustHappen.getMessage());
        }
        assertTrue(m_works_at.isInOIModel());
    }
    public void testAddPropertyDomain1() throws Exception {
        m_evolutionStrategy.setDomainRangeShape(EvolutionStrategyImpl.DOMAIN_RANGE_SHAPE_ALLOW_REPEATED_SUBCONCEPTS);
        applyChange(new AddPropertyDomain(m_phdStudent_works_at,m_institution));
        assertSetEquals(m_phdStudent_works_at.getDomainConcepts(),new Object[] { m_phdStudent,m_institution });
        assertSetEquals(m_institution.getPropertiesFromConcept(),new Object[] { m_phdStudent_works_at,m_type,m_name });
        assertSetEquals(m_student.getPropertiesFromConcept(),new Object[] { m_student_works_at });
        m_evolutionStrategy.setDomainRangeShape(EvolutionStrategyImpl.DOMAIN_RANGE_SHAPE_DISALLOW_REPEATED_SUBCONCEPTS);
        applyChange(new AddPropertyDomain(m_phdStudent_works_at,m_student));
        assertSetEquals(m_phdStudent_works_at.getDomainConcepts(),new Object[] { m_student,m_institution });
        assertSetEquals(m_student.getPropertiesFromConcept(),new Object[] { m_student_works_at,m_phdStudent_works_at });
        m_evolutionStrategy.setDomainRangeShape(EvolutionStrategyImpl.DOMAIN_RANGE_SHAPE_ALLOW_REPEATED_SUBCONCEPTS);
        applyChange(new AddPropertyDomain(m_phdStudent_works_at,m_person));
        assertSetEquals(m_phdStudent_works_at.getDomainConcepts(),new Object[] { m_student,m_institution,m_person });
        assertSetEquals(m_person.getPropertiesFromConcept(),new Object[] { m_works_at,m_phdStudent_works_at,m_address,m_name,m_cooperates_with });
    }
    public void testAddPropertyDomain2() throws Exception {
        m_evolutionStrategy.setDomainRangeShape(EvolutionStrategyImpl.DOMAIN_RANGE_SHAPE_DISALLOW_REPEATED_SUBCONCEPTS);
        try {
            applyChange(new AddPropertyDomain(m_works_at,m_student));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Domain of property 'test:works_at' already contains concept 'test:Person' that is the superconcept of concept 'test:Student' that is being added to the domain.",mustHappen.getMessage());
        }
        assertSetEquals(m_works_at.getDomainConcepts(),new Object[] { m_person });
        assertSetEquals(m_person.getAllPropertiesFromConcept(),new Object[] { m_works_at,m_address,m_name,m_cooperates_with,m_explanation });
        m_evolutionStrategy.setDomainRangeShape(EvolutionStrategyImpl.DOMAIN_RANGE_SHAPE_ALLOW_REPEATED_SUBCONCEPTS);
        applyChange(new AddPropertyDomain(m_works_at,m_student));
        assertSetEquals(m_works_at.getDomainConcepts(),new Object[] { m_person,m_student });
        assertSetEquals(m_student.getPropertiesFromConcept(),new Object[] { m_student_works_at,m_works_at });
    }
    public void testAddExistingPropertyDomain() throws Exception {
        try {
            applyChange(new AddPropertyDomain(m_works_at,m_person));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:Person' is already a domain concept of property 'test:works_at'.",mustHappen.getMessage());
        }
    }
    public void testRemoveNonExistingPropertyDomain() throws Exception {
        try {
            applyChange(new RemovePropertyDomain(m_works_at,m_project));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:Project' is not in the domain of property 'test:works_at'.",mustHappen.getMessage());
        }
    }
    public void testRemovePropertyDomain1() throws Exception {
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_ALLOW);
        applyChange(new RemovePropertyDomain(m_works_at,m_person));
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_person.getPropertiesFromConcept(),new Object[] { m_address,m_name,m_cooperates_with });
    }
    public void testRemovePropertyDomain2() throws Exception {
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        applyChange(new RemovePropertyDomain(m_works_at,m_person));
        assertTrue(!m_works_at.isInOIModel());
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_person.getPropertiesFromConcept(),new Object[] { m_address,m_cooperates_with,m_name });
        assertSetEquals(m_personAlex.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personBoris.getFromPropertyValues(m_works_at),null);
    }
    public void testRemovePropertyDomain3() throws Exception {
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_DO_NOT_ENFORCE);
        applyChange(new RemovePropertyDomain(m_works_at,m_person));
        assertTrue(!m_works_at.isInOIModel());
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_personAlex.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_personBoris.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
    }
    public void testAddRemoveDomain() throws Exception {
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        assertSetEquals(m_phdStudentInstance.getFromPropertyValues(m_phdStudent_works_at),new Object[] { m_studentProject });
        applyChanges(new ChangeEvent[] { new AddPropertyDomain(m_phdStudent_works_at,m_institution),new RemovePropertyDomain(m_phdStudent_works_at,m_phdStudent),new AddPropertyDomain(m_phdStudent_works_at,m_phdStudent),new RemovePropertyDomain(m_phdStudent_works_at,m_institution) });
        assertTrue(m_phdStudent_works_at.isInOIModel());
        assertSetEquals(m_phdStudent_works_at.getDomainConcepts(),new Object[] { m_phdStudent });
        assertSetEquals(m_institution.getPropertiesFromConcept(),new Object[] { m_name,m_type });
        assertSetEquals(m_phdStudentInstance.getFromPropertyValues(m_phdStudent_works_at),null);
    }
    public void testRemovePropertyDomainAll() throws Exception {
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
        applyChange(new RemovePropertyDomain(m_works_at,m_person));
        assertTrue(!m_works_at.isInOIModel());
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_person.getPropertiesFromConcept(),new Object[] { m_address,m_name,m_cooperates_with });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_cooperates_with),new Object[] { m_personAlex });
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_ALLOW);
        applyChange(new RemovePropertyDomain(m_cooperates_with,m_person));
        assertTrue(m_cooperates_with.isInOIModel());
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_cooperates_with),null);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_DO_NOT_ENFORCE);
        applyChange(new RemovePropertyDomain(m_name,m_person));
        assertTrue(m_name.isInOIModel());
        assertEquals("Ljiljana Stojanovic",m_personLjiljana.getFromPropertyValue(m_name));
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        applyChange(new RemovePropertyDomain(m_address,m_person));
        assertTrue(!m_address.isInOIModel());
        assertEquals("Vorholz Str. 28",m_personLjiljana.getFromPropertyValue(m_address));
    }
    public void testAddSubProperty() throws Exception {
        Property newProperty=m_oimodel.getProperty("test:newProperty");
        applyChange(new AddEntity(newProperty));
        assertTrue(!newProperty.isSubPropertyOf(m_name));
        assertTrue(!newProperty.getSubProperties().contains(m_name));
        applyChange(new AddSubProperty(m_name,newProperty));
        assertTrue(newProperty.isSubPropertyOf(m_name));
        assertTrue(!newProperty.getSubProperties().contains(m_name));
        try {
            applyChange(new AddSubProperty(newProperty,m_name));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Making property 'test:name' a subproperty of property 'test:newProperty' would result in property hierarchy cycles.",mustHappen.getMessage());
        }
        assertTrue(newProperty.isSubPropertyOf(m_name));
        assertTrue(!newProperty.getSubProperties().contains(m_name));
        try {
            applyChange(new AddSubProperty(m_name,newProperty));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Property 'test:newProperty' is already a subproperty of property 'test:name'.",mustHappen.getMessage());
        }
        assertTrue(newProperty.isSubPropertyOf(m_name));
        assertTrue(!newProperty.getSubProperties().contains(m_name));
    }
    public void testRemoveSubProperty() throws Exception {
        assertTrue(m_works_at.getSubProperties().contains(m_student_works_at));
        assertTrue(m_student_works_at.getSuperProperties().contains(m_works_at));
        assertTrue(!m_student_works_at.getSubProperties().contains(m_works_at));
        try {
            applyChange(new RemoveSubProperty(m_student_works_at,m_works_at));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Property 'test:works_at' is not a subproperty of property 'test:student_works_at'.",mustHappen.getMessage());
        }
        applyChange(new RemoveSubProperty(m_works_at,m_student_works_at));
        assertTrue(!m_works_at.getSubProperties().contains(m_student_works_at));
        assertTrue(!m_student_works_at.getSuperProperties().contains(m_works_at));
    }
    public void testAddPropertyRange1() throws Exception {
        assertTrue(!m_works_at.isRangeConcept(m_student));
        applyChange(new AddPropertyRange(m_works_at,m_student));
        assertSetEquals(m_works_at.getRangeConcepts(),new Object[] { m_project,m_student });
    }
    public void testAddPropertyRange2() throws Exception {
        assertTrue(m_name.isAttribute());
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        applyChanges(new ChangeEvent[] { new AddPropertyRange(m_name,m_student),new AddPropertyRange(m_name,m_institution) });
        assertTrue(!m_name.isAttribute());
        assertSetEquals(m_name.getRangeConcepts(),new Object[] { m_student,m_institution });
        assertNull(m_personLjiljana.getFromPropertyValue(m_name));
    }
    public void testAddPropertyRange3() throws Exception {
        assertTrue(!m_works_at.isAttribute());
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        applyChange(new SetPropertyIsAttribute(m_works_at,true));
        assertTrue(m_works_at.isAttribute());
        assertSetEquals(m_works_at.getRangeConcepts(),null);
        assertNull(m_personLjiljana.getFromPropertyValue(m_works_at));
        assertNull(m_personAlex.getFromPropertyValue(m_works_at));
        assertNull(m_personBoris.getFromPropertyValue(m_works_at));
    }
    public void testAddPropertyRange4() throws Exception {
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        Property property=m_oimodel.getProperty("test:newWork_at");
        Concept concept1=m_oimodel.getConcept("test:ResearchProject");
        Concept concept2=m_oimodel.getConcept("test:phDStudentResearchProject");
        Instance instanceDomain=m_oimodel.getInstance("test:newInstanceDomain");
        Instance instanceRange=m_oimodel.getInstance("test:newInstanceRange");
        applyChanges(new ChangeEvent[] {
            new AddEntity(concept1),
            new AddEntity(concept2),
            new AddSubConcept(m_project,concept1),
            new AddSubConcept(concept1,concept2),
            new AddEntity(property),
            new AddPropertyDomain(property,m_institution),
            new AddPropertyRange(property,concept1),
            new AddEntity(instanceDomain),
            new AddInstanceOf(m_institution,instanceDomain),
            new AddEntity(instanceRange),
            new AddInstanceOf(concept1,instanceRange),
            new AddPropertyInstance(property,instanceDomain,instanceRange),
            new AddPropertyRange(property,concept2),
        });
    }
    public void testAddExistingPropertyRange() throws Exception {
        try {
            applyChange(new AddPropertyRange(m_works_at,m_project));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:Project' is already a range concept of property 'test:works_at'.",mustHappen.getMessage());
        }
        try {
            applyChange(new SetPropertyIsAttribute(m_name,true));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Property 'test:name' already has required attribute status.",mustHappen.getMessage());
        }
    }
}