package edu.unika.aifb.kaon.defaultevolution.test;

import java.util.List;
import java.util.LinkedList;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.util.*;
import edu.unika.aifb.kaon.defaultevolution.*;

public class EvolutionStrategyLexicalEntryTest extends EvolutionStrategyTestXMLTest {

    public EvolutionStrategyLexicalEntryTest(String name) {
        super(name);
    }
    public void testAddLexicalEntry() throws Exception {
        LexicalEntry lexicalEntry=m_oimodel.getLexicalEntry("test:XXX");
        assertTrue(!lexicalEntry.isInOIModel());
        applyChanges(LexiconUtil.addLexicalEntry(lexicalEntry,KAON_Label));
        assertTrue(lexicalEntry.isInOIModel());
    }
    public void testAddExistingLexicalEntry() throws Exception {
        assertTrue(m_ljiljana_label_en.isInOIModel());
        try {
            applyChanges(LexiconUtil.addLexicalEntry(m_ljiljana_label_en,KAON_Label));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:123' is in OI model.",mustHappen.getMessage());
        }
        assertTrue(m_ljiljana_label_en.isInOIModel());
    }
    public void testRemoveLexicalEntry() throws Exception {
        assertTrue(m_ljiljana_label_en.isInOIModel());
        assertSetEquals(m_personLjiljana.getLexicalEntries(),new Object[] { m_ljiljana_label_en });
        applyChange(new RemoveEntity(m_ljiljana_label_en));
        assertTrue(!m_ljiljana_label_en.isInOIModel());
        assertSetEquals(m_personLjiljana.getLexicalEntries(),null);
    }
    public void testRemoveNonExistingLexicalEntry() throws Exception {
        LexicalEntry lexicalEntry=m_oimodel.getLexicalEntry("test:111123");
        assertTrue(!lexicalEntry.isInOIModel());
        try {
            applyChange(new RemoveEntity(lexicalEntry));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:111123' is not in OI model.",mustHappen.getMessage());
        }
        assertTrue(!lexicalEntry.isInOIModel());
    }
    public void testAddLexicalReference() throws Exception {
        assertSetEquals(m_person_label_en.getReferencedEntities(),new Object[] { m_person.getSpanningInstance() });
        applyChanges(LexiconUtil.addLexicalReference(m_person_label_en,m_project));
        assertSetEquals(m_person_label_en.getReferencedEntities(),new Object[] { m_person.getSpanningInstance(),m_project.getSpanningInstance() });
        try {
            applyChanges(LexiconUtil.addLexicalReference(m_person_label_en,m_person));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("PropertyInstance already exists.",mustHappen.getMessage());
        }
        assertSetEquals(m_person_label_en.getReferencedEntities(),new Object[] { m_person.getSpanningInstance(),m_project.getSpanningInstance() });
        applyChange(new RemoveEntity(m_project));
        assertSetEquals(m_person_label_en.getReferencedEntities(),new Object[] { m_person.getSpanningInstance() });
        applyChange(new RemoveEntity(m_person_label_en));
        assertSetEquals(m_person_label_en.getReferencedEntities(),null);
        assertSetEquals(m_person.getLexicalEntries(),new Object[] { m_oimodel.getLexicalEntry("test:11161"),m_oimodel.getLexicalEntry("test:22261")} );
    }
    public void testAddRemoveLexicalReference() throws Exception {
        Concept conceptOldReference=m_oimodel.getConcept("test:Person");
        Concept conceptNewReference=m_oimodel.getConcept("test:Project");
        assertSetEquals(m_person_label_en.getReferencedEntities(),new Object[] { m_person.getSpanningInstance() });
        List changes=new LinkedList();
        changes.addAll(LexiconUtil.addLexicalReference(m_person_label_en,m_project));
        changes.addAll(LexiconUtil.removeLexicalReference(m_person_label_en,m_project));
        changes.addAll(LexiconUtil.addLexicalReference(m_person_label_en,m_project));
        changes.addAll(LexiconUtil.removeLexicalReference(m_person_label_en,m_person));
        changes.addAll(LexiconUtil.removeLexicalReference(m_person_label_en,m_project));
        applyChanges(changes);
        assertSetEquals(m_person_label_en.getReferencedEntities(),null);
    }
}