package edu.unika.aifb.kaon.defaultevolution.test;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.defaultevolution.*;

public class EvolutionStrategyInstanceTest extends EvolutionStrategyTestXMLTest {

    public EvolutionStrategyInstanceTest(String name) {
        super(name);
    }
    public void testAddInstance() throws Exception {
        Instance instance=m_oimodel.getInstance("test:XXX");
        assertTrue(!instance.isInOIModel());
        applyChanges(new ChangeEvent[] { new AddEntity(instance),new AddInstanceOf(m_person,instance) });
        assertTrue(instance.isInOIModel());
    }
    public void testAddExistingInstance() throws Exception {
        assertTrue(m_personLjiljana.isInOIModel());
        try {
            applyChange(new AddEntity(m_personLjiljana));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:122' is in OI model.",mustHappen.getMessage());
        }
        assertTrue(m_personLjiljana.isInOIModel());
    }
    public void testRemoveInstance() throws Exception {
        assertTrue(m_phdStudentInstance.isInOIModel());
        applyChange(new RemoveEntity(m_phdStudentInstance));
        assertTrue(!m_phdStudentInstance.isInOIModel());
    }
    public void testRemoveNonExistingInstance() throws Exception {
        Instance instance=m_oimodel.getInstance("test:111122");
        assertTrue(!instance.isInOIModel());
        try {
            applyChange(new RemoveEntity(instance));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:111122' is not in OI model.",mustHappen.getMessage());
        }
        assertTrue(!instance.isInOIModel());
    }
    public void testAddInstanceOf() throws Exception {
        assertTrue(m_personLjiljana.getParentConcepts().contains(m_person));
        assertSetEquals(m_person.getInstances(),new Object[] { m_personLjiljana,m_personAlex,m_personBoris });
        try {
            applyChange(new AddInstanceOf(m_person,m_personLjiljana));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Instance 'test:122' is already an instance of concept 'test:Person'.",mustHappen.getMessage());
        }
        applyChange(new AddInstanceOf(m_project,m_personLjiljana));
        assertSetEquals(m_person.getInstances(),new Object[] { m_personLjiljana,m_personAlex,m_personBoris });
        assertSetEquals(m_project.getInstances(),new Object[] { m_personLjiljana,m_projectOntoLogging,m_studentProject });
        assertSetEquals(m_personLjiljana.getParentConcepts(),new Object[] { m_person,m_project,m_root });
    }
    public void testRemoveInstanceOf() throws Exception {
        assertTrue(m_personLjiljana.getParentConcepts().contains(m_person));
        applyChange(new RemoveInstanceOf(m_person,m_personLjiljana));
        assertSetEquals(m_personLjiljana.getParentConcepts(),new Object[] { m_root });
        assertSetEquals(m_person.getInstances(),new Object[] { m_personAlex,m_personBoris });
        try {
            applyChange(new RemoveInstanceOf(m_project,m_personLjiljana));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:122' is not in OI model.",mustHappen.getMessage());
        }
        assertTrue(!m_personLjiljana.getParentConcepts().contains(m_project));
    }
    public void testAddPropertyInstance1() throws Exception {
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "Ljiljana Stojanovic" });
        applyChanges(new ChangeEvent[] { new AddPropertyInstance(m_works_at,m_personLjiljana,m_studentProject),new AddPropertyInstance(m_name,m_personLjiljana,"STRING") });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging,m_studentProject });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "Ljiljana Stojanovic","STRING" });
        try {
            applyChange(new AddPropertyInstance(m_works_at,m_personLjiljana,m_studentProject));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("PropertyInstance already exists.",mustHappen.getMessage());
        }
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging,m_studentProject });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "Ljiljana Stojanovic","STRING" });
    }
    public void testAddPropertyInstance2() throws Exception {
        try {
            applyChange(new AddPropertyInstance(m_hasProject,m_personLjiljana,m_studentProject));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Instance 'test:122' does not follow the domain constraint of property 'test:has_Project'.",mustHappen.getMessage());
        }
        try {
            applyChange(new AddPropertyInstance(m_type,m_personLjiljana,"STRING"));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Instance 'test:122' does not follow the domain constraint of property 'test:type'.",mustHappen.getMessage());
        }
        try {
            applyChange(new AddPropertyInstance(m_works_at,m_personLjiljana,m_personLjiljana));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Instance 'test:122' does not follow the range constraint of property 'test:works_at'.",mustHappen.getMessage());
        }
        try {
            applyChange(new AddPropertyInstance(m_name,m_personLjiljana,m_personLjiljana));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Property 'test:name' is an attribute, so its value cannot contain an instance.",mustHappen.getMessage());
        }
    }
    public void testRemovePropertyInstance() throws Exception {
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "Ljiljana Stojanovic" });
        applyChanges(new ChangeEvent[] { new RemovePropertyInstance(m_works_at,m_personLjiljana,m_projectOntoLogging),new RemovePropertyInstance(m_name,m_personLjiljana,"Ljiljana Stojanovic") });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),null);
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),null);
        try {
            applyChange(new RemovePropertyInstance(m_works_at,m_personLjiljana,m_studentProject));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("PropertyInstance doesn't exist.",mustHappen.getMessage());
        }
        try {
            applyChange(new RemovePropertyInstance(m_name,m_personLjiljana,"STRING"));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("PropertyInstance doesn't exist.",mustHappen.getMessage());
        }
    }
    public void testSetPropertyInstanceValue() throws Exception {
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_projectOntoLogging });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "Ljiljana Stojanovic" });
        applyChanges(new ChangeEvent[] { new SetPropertyInstanceValue(m_works_at,m_personLjiljana,m_studentProject),new SetPropertyInstanceValue(m_name,m_personLjiljana,"STRING") });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_works_at),new Object[] { m_studentProject });
        assertSetEquals(m_personLjiljana.getFromPropertyValues(m_name),new Object[] { "STRING" });
    }
}