package edu.unika.aifb.kaon.defaultevolution.test;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.defaultevolution.*;

public class EvolutionStrategyConceptTest extends EvolutionStrategyTestXMLTest {

    public EvolutionStrategyConceptTest(String name) {
        super(name);
    }
    public void testAddConcept() throws Exception {
        Concept concept=m_oimodel.getConcept("test:newConcept");
        assertTrue(!concept.isInOIModel());
        assertTrue(!m_oimodel.getConcepts().contains(concept));
        applyChange(new AddEntity(concept));
        assertTrue(concept.isInOIModel());
        assertTrue(m_oimodel.getConcepts().contains(concept));
    }
    public void testAddRemoveNewConcept1() throws Exception {
        Concept concept=m_oimodel.getConcept("test:newConcept");
        assertTrue(!concept.isInOIModel());
        assertTrue(!m_oimodel.getConcepts().contains(concept));
        applyChanges(new ChangeEvent[] { new AddEntity(concept),new RemoveEntity(concept),new AddEntity(concept) });
        assertTrue(concept.isInOIModel());
        assertTrue(m_oimodel.getConcepts().contains(concept));
    }
    public void testAddRemoveNewConcept2() throws Exception {
        Concept concept=m_oimodel.getConcept("test:newConcept");
        assertTrue(!concept.isInOIModel());
        assertTrue(!m_oimodel.getConcepts().contains(concept));
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(concept),new RemoveEntity(concept),new AddEntity(concept),new AddEntity(concept) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:newConcept' is in OI model.",mustHappen.getMessage());
        }
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(concept),new RemoveEntity(concept),new RemoveEntity(concept) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:newConcept' is not in OI model.",mustHappen.getMessage());
        }
    }
    public void testAddRemoveExistingConcept() throws Exception {
        assertTrue(m_hiwi.isInOIModel());
        try {
            applyChanges(new ChangeEvent[] { new RemoveEntity(m_hiwi),new AddEntity(m_hiwi),new RemoveEntity(m_hiwi),new AddEntity(m_hiwi),new AddEntity(m_hiwi) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:HiWi' is in OI model.",mustHappen.getMessage());
        }
        try {
            applyChanges(new ChangeEvent[] { new RemoveEntity(m_hiwi),new AddEntity(m_hiwi),new RemoveEntity(m_hiwi),new RemoveEntity(m_hiwi),new AddEntity(m_hiwi),new AddEntity(m_hiwi) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:HiWi' is not in OI model.",mustHappen.getMessage());
        }
        assertTrue(m_oimodel.getConcepts().contains(m_hiwi));
    }
    public void testAddExistingConcept() throws Exception {
        try {
            applyChange(new AddEntity(m_person));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Entity with URI 'test:Person' is in OI model.",mustHappen.getMessage());
        }
        assertTrue(m_oimodel.getConcepts().contains(m_person));
    }
    public void testAddExistingSubConcept() throws Exception {
        assertTrue(m_person.getSubConcepts().contains(m_student));
        try {
            applyChange(new AddSubConcept(m_person,m_student));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:Student' is already a subconcept of concept 'test:Person'.",mustHappen.getMessage());
        }
        assertTrue(m_person.getSubConcepts().contains(m_student));
    }
    public void testAddSubConcept1() throws Exception {
        Concept personChild=m_oimodel.getConcept("test:Person-Child");
        applyChanges(new ChangeEvent[] { new AddEntity(personChild),new AddSubConcept(m_person,personChild) });
        assertTrue(personChild.isInOIModel());
        assertTrue(m_person.getSubConcepts().contains(personChild));
        assertTrue(!personChild.getSubConcepts().contains(m_person));
        try {
            applyChange(new AddSubConcept(personChild,m_person));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Making concept 'test:Person' a subconcept of concept 'test:Person-Child' would create a hierarchy cycle.",mustHappen.getMessage());
        }
        assertTrue(m_person.getSubConcepts().contains(personChild));
        assertTrue(!personChild.getSubConcepts().contains(m_person));
    }
    public void testAddSubConcept2() throws Exception {
        Concept personChild=m_oimodel.getConcept("test:Person-Child");
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(personChild),new AddSubConcept(m_person,personChild),new AddSubConcept(personChild,m_person) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Making concept 'test:Person' a subconcept of concept 'test:Person-Child' would create a hierarchy cycle.",mustHappen.getMessage());
        }
        assertTrue(m_person.isInOIModel());
        assertTrue(!personChild.isInOIModel());
        assertTrue(m_oimodel.getConcepts().contains(m_person));
        assertTrue(!m_oimodel.getConcepts().contains(personChild));
        assertTrue(!m_person.getSubConcepts().contains(personChild));
        assertTrue(!personChild.getSubConcepts().contains(m_person));
        assertTrue(!m_person.getSuperConcepts().contains(personChild));
        assertTrue(!personChild.getSuperConcepts().contains(m_person));
    }
   public void testAddSubConcept3() throws Exception {
        m_evolutionStrategy.setConceptHierarchyShape(EvolutionStrategyImpl.CONCEPT_HIERARCHY_SHAPE_REMOVE_MULTIPLE_PATHS);
        Concept conceptX=m_oimodel.getConcept("test:XXX");
        applyChanges(new ChangeEvent[] { new AddEntity(conceptX),new AddSubConcept(m_person,conceptX),new AddSubConcept(m_student,conceptX) });
        assertTrue(!conceptX.isDirectSubConceptOf(m_person));
        assertTrue(conceptX.isDirectSubConceptOf(m_student));
        assertTrue(conceptX.isSubConceptOf(m_person));
        Concept conceptY=m_oimodel.getConcept("test:YYY");
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(conceptY),new AddSubConcept(m_student,conceptY),new AddSubConcept(m_person,conceptY) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:YYY' is already indirectly a subconcept of concept 'test:Person'.",mustHappen.getMessage());
        }
    }
   public void testAddSubConcept4() throws Exception {
        m_evolutionStrategy.setConceptHierarchyShape(EvolutionStrategyImpl.CONCEPT_HIERARCHY_SHAPE_DO_NOT_ALLOW_MULTIPLE_PATHS);
        Concept conceptX=m_oimodel.getConcept("test:XXX");
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(conceptX),new AddSubConcept(m_person,conceptX),new AddSubConcept(m_student,conceptX) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:XXX' is already a direct subconcept of concept 'test:Person', and making it a subconcept of 'test:Student' would open antoher link.",mustHappen.getMessage());
        }
        Concept conceptY=m_oimodel.getConcept("test:YYY");
        try {
            applyChanges(new ChangeEvent[] { new AddEntity(conceptY),new AddSubConcept(m_student,conceptY),new AddSubConcept(m_person,conceptY) });
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:YYY' is already indirectly a subconcept of concept 'test:Person'.",mustHappen.getMessage());
        }
    }
    public void testRemoveConcept1() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_DELETE);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_ALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_ALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        m_evolutionStrategy.setOrphanedInstances(EvolutionStrategyImpl.ORPHANED_INSTANCES_DELETE);
        applyChange(new RemoveEntity(m_student));
        assertTrue(m_phdStudent.isInOIModel());
        assertSetEquals(m_phdStudent.getSuperConcepts(),new Object[] { m_employee });
        assertTrue(!m_student.isInOIModel());
        assertTrue(!m_hiwi.isInOIModel());
        assertTrue(m_student_works_at.isInOIModel());
        assertSetEquals(m_student_works_at.getDomainConcepts(),null);
        assertTrue(m_phdStudent_works_at.isInOIModel());
        assertSetEquals(m_phdStudent_works_at.getDomainConcepts(),new Object[] { m_phdStudent });
        assertTrue(!m_studentInstance.isInOIModel());
        assertSetEquals(m_studentProject.getToPropertyValues(m_student_works_at),null);
        assertTrue(!m_student_label_en.isInOIModel());
        assertTrue(m_all_students_label_en.isInOIModel());
        assertSetEquals(m_all_students_label_en.getReferencedEntities(),new Object[] { m_phdStudent.getSpanningInstance() });
    }
    public void testRemoveConcept2() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_RECONNECT_TO_SUPER);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_ALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_ALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_DO_NOT_ENFORCE);
        applyChange(new RemoveEntity(m_person));
        assertTrue(m_employee.isInOIModel());
        assertTrue(m_employee.isDirectSubConceptOf(m_root));
        assertTrue(m_student.isInOIModel());
        assertTrue(m_student.isDirectSubConceptOf(m_root));
        assertTrue(m_works_at.isInOIModel());
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_works_at.getRangeConcepts(),new Object[] { m_project });
        assertTrue(m_address.isInOIModel());
        assertSetEquals(m_address.getDomainConcepts(),null);
        assertSetEquals(m_address.getRangeConcepts(),null);
        assertTrue(m_address.isAttribute());
        assertTrue(m_cooperates_with.isInOIModel());
        assertSetEquals(m_cooperates_with.getDomainConcepts(),null);
        assertSetEquals(m_cooperates_with.getRangeConcepts(),null);
    }
    public void testRemoveConcept3() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_RECONNECT_TO_SUPER);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_ALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_DO_NOT_ENFORCE);
        applyChange(new RemoveEntity(m_person));
        assertTrue(m_employee.isInOIModel());
        assertTrue(m_employee.isDirectSubConceptOf(m_root));
        assertTrue(m_student.isInOIModel());
        assertTrue(m_student.isDirectSubConceptOf(m_root));
        assertTrue(m_works_at.isInOIModel());
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_works_at.getRangeConcepts(),new Object[] { m_project });
        assertTrue(m_address.isInOIModel());
        assertSetEquals(m_address.getDomainConcepts(),null);
        assertSetEquals(m_address.getRangeConcepts(),null);
        assertTrue(m_address.isAttribute());
        assertTrue(!m_cooperates_with.isInOIModel());
        assertSetEquals(m_cooperates_with.getDomainConcepts(),null);
        assertSetEquals(m_cooperates_with.getRangeConcepts(),null);
    }
    public void testRemoveConcept4() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_RECONNECT_TO_SUPER);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_DO_NOT_ENFORCE);
        applyChange(new RemoveEntity(m_person));
        assertTrue(m_employee.isInOIModel());
        assertTrue(m_employee.isDirectSubConceptOf(m_root));
        assertTrue(m_student.isInOIModel());
        assertTrue(m_student.isDirectSubConceptOf(m_root));
        assertTrue(!m_works_at.isInOIModel());
        assertSetEquals(m_works_at.getDomainConcepts(),null);
        assertSetEquals(m_works_at.getRangeConcepts(),null);
        assertTrue(!m_address.isInOIModel());
        assertSetEquals(m_address.getDomainConcepts(),null);
        assertSetEquals(m_address.getRangeConcepts(),null);
        assertTrue(!m_address.isAttribute());
        assertTrue(!m_cooperates_with.isInOIModel());
        assertSetEquals(m_cooperates_with.getDomainConcepts(),null);
        assertSetEquals(m_cooperates_with.getRangeConcepts(),null);
    }
    public void testRemoveSubConcept1() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_DELETE);
        m_evolutionStrategy.setPropertyPropagation(EvolutionStrategyImpl.PROPERTY_PROPAGATION_NO);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        try {
            applyChange(new RemoveSubConcept(m_person,m_phdStudent));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Concept 'test:PhDStudent' is not a direct subconcept of concept 'test:Person'.",mustHappen.getMessage());
        }
        applyChange(new RemoveSubConcept(m_person,m_student));
        assertTrue(m_student.isInOIModel());
        assertTrue(m_student.isDirectSubConceptOf(m_root));
        assertTrue(m_hiwi.isInOIModel());
        assertTrue(m_phdStudent.isInOIModel());
        assertTrue(m_works_at.isInOIModel());
        assertTrue(m_student_works_at.isInOIModel());
        assertTrue(m_phdStudent_works_at.isInOIModel());
        assertSetEquals(m_phdStudent_works_at.getSuperProperties(),new Object[] { m_student_works_at });
        assertTrue(m_studentInstance.isInOIModel());
        assertSetEquals(m_student.getAllPropertiesFromConcept(),new Object[] { m_student_works_at,m_explanation });
    }
    public void testRemoveSubConcept2() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_DELETE);
        m_evolutionStrategy.setPropertyPropagation(EvolutionStrategyImpl.PROPERTY_PROPAGATION_ALL);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        applyChange(new RemoveSubConcept(m_person,m_student));
        assertTrue(m_student.isInOIModel());
        assertTrue(m_student.isDirectSubConceptOf(m_root));
        assertTrue(m_hiwi.isInOIModel());
        assertTrue(m_phdStudent.isInOIModel());
        assertTrue(m_works_at.isInOIModel());
        assertTrue(m_student_works_at.isInOIModel());
        assertTrue(m_phdStudent_works_at.isInOIModel());
        assertSetEquals(m_phdStudent_works_at.getSuperProperties(),new Object[] { m_student_works_at });
        assertTrue(m_studentInstance.isInOIModel());
        assertSetEquals(m_student.getAllPropertiesFromConcept(),new Object[] { m_cooperates_with,m_name,m_address,m_works_at,m_student_works_at,m_explanation });
    }
    public void testRemoveSubConcept3() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_DELETE);
        m_evolutionStrategy.setPropertyPropagation(EvolutionStrategyImpl.PROPERTY_PROPAGATION_EXPLICIT);
        m_evolutionStrategy.setPropertyDomainEmpty(EvolutionStrategyImpl.PROPERTY_DOMAIN_EMPTY_DISALLOW);
        m_evolutionStrategy.setPropertyRangeEmpty(EvolutionStrategyImpl.PROPERTY_RANGE_EMPTY_DISALLOW);
        m_evolutionStrategy.setInstanceConsistency(EvolutionStrategyImpl.INSTANCE_CONSISTENCY_ENFORCE);
        applyChange(new RemoveSubConcept(m_student,m_phdStudent));
        assertTrue(m_student.isInOIModel());
        assertTrue(m_hiwi.isInOIModel());
        assertTrue(m_phdStudent.isInOIModel());
        assertTrue(m_works_at.isInOIModel());
        assertTrue(m_student_works_at.isInOIModel());
        assertTrue(m_phdStudent_works_at.isInOIModel());
        assertSetEquals(m_phdStudent_works_at.getSuperProperties(),new Object[] { m_student_works_at });
        assertTrue(m_studentInstance.isInOIModel());
        assertSetEquals(m_phdStudent.getAllPropertiesFromConcept(),new Object[] { m_cooperates_with,m_name,m_address,m_works_at,m_student_works_at,m_phdStudent_works_at,m_explanation });
        applyChange(new RemoveSubConcept(m_employee,m_phdStudent));
        assertTrue(m_phdStudent.isDirectSubConceptOf(m_root));
        assertSetEquals(m_phdStudent.getAllPropertiesFromConcept(),new Object[] { m_student_works_at,m_phdStudent_works_at,m_explanation });
    }
    public void testRemoveSubConceptOfRoot() throws Exception {
        try {
            applyChange(new RemoveSubConcept(m_root,m_institution));
            fail();
        }
        catch (KAONException mustHappen) {
            assertEquals("Cannot detach concept 'test:Institution' from root, since root is the single parent.",mustHappen.getMessage());
        }
    }
    public void testDeleteSpanningInstance() throws Exception {
        try {
            applyChange(new RemoveEntity(m_employee.getSpanningInstance()));
        }
        catch (KAONException mustHappen) {
            assertEquals("Cannot remove an instance from the model if it has a spanning concept in the model as well.",mustHappen.getMessage());
        }
    }
    public void testAddConceptAndSpanningInstance() throws Exception {
        Concept personChild=m_oimodel.getConcept("test:Person-Child");
        Instance personChildInstance=personChild.getSpanningInstance();
        applyChanges(new ChangeEvent[] { new AddEntity(personChild),new AddSubConcept(m_person,personChild),new SetPropertyInstanceValue(m_explanation,personChildInstance,"explanation_value") });
        assertTrue(personChild.isInOIModel());
        assertTrue(personChildInstance.isInOIModel());
        assertTrue(m_person.getSubConcepts().contains(personChild));
        assertTrue(!personChild.getSubConcepts().contains(m_person));
        assertSetEquals(personChildInstance.getParentConcepts(),new Object[] { m_root });
        assertEquals("explanation_value",personChildInstance.getFromPropertyValue(m_explanation));
    }
    public void testRemoveTwoParents1() throws Exception {
        Concept person=m_oimodel.getConcept("test:Person");
        Concept employee=m_oimodel.getConcept("test:Employee");
        Concept student=m_oimodel.getConcept("test:Student");
        Concept phdStudent=m_oimodel.getConcept("test:PhDStudent");
        applyChange(new RemoveEntity(employee));
        assertTrue(!phdStudent.isDirectSubConceptOf(person));
        assertTrue(phdStudent.isSubConceptOf(person));
        applyChange(new RemoveEntity(student));
        assertTrue(phdStudent.isDirectSubConceptOf(person));
    }
    public void testRemoveTwoParents2() throws Exception {
        m_evolutionStrategy.setOrphanedConcepts(EvolutionStrategyImpl.ORPHANED_CONCEPTS_RECONNECT_TO_ROOT);
        Concept employee=m_oimodel.getConcept("test:Employee");
        Concept student=m_oimodel.getConcept("test:Student");
        Concept phdStudent=m_oimodel.getConcept("test:PhDStudent");
        applyChange(new RemoveEntity(employee));
        assertTrue(!phdStudent.isDirectSubConceptOf(m_oimodel.getRootConcept()));
        assertTrue(phdStudent.isSubConceptOf(m_oimodel.getRootConcept()));
        applyChange(new RemoveEntity(student));
        assertTrue(phdStudent.isDirectSubConceptOf(m_oimodel.getRootConcept()));
    }
}
