package edu.unika.aifb.kaon.defaultevolution.test;

import junit.framework.TestCase;
import java.util.Set;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collections;
import java.net.URL;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import edu.unika.aifb.kaon.apionrdf.*;

import edu.unika.aifb.kaon.defaultevolution.*;

/**
 * Abstract class for all tests that sets up an in-memory RDF model and contains various utility methods.
 */
public abstract class EvolutionStrategyBaseTest extends TestCase {
    protected static final String KAON_Label="http://kaon.semanticweb.org/2001/11/kaon-lexical#Label";
    protected static final String KAON_Documentation="http://kaon.semanticweb.org/2001/11/kaon-lexical#Documentation";
    protected static final String EN="http://kaon.semanticweb.org/2001/11/kaon-lexical#en";
    protected static final String DE="http://kaon.semanticweb.org/2001/11/kaon-lexical#de";
    protected static final String VALUE="http://kaon.semanticweb.org/2001/11/kaon-lexical#value";
    protected static final String KAON_references="http://kaon.semanticweb.org/2001/11/kaon-lexical#references";
    protected static final String KAON_inLanguage="http://kaon.semanticweb.org/2001/11/kaon-lexical#inLanguage";

    protected EvolutionStrategyImpl m_evolutionStrategy;
    protected OIModel m_oimodel;

    public EvolutionStrategyBaseTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        Model model=RDFManager.createModel("file:///c:/temp/test.kaon",null);
        addModel(model,getDefaultModel());
        KAONConnectionImpl connection=new KAONConnectionImpl();
        m_oimodel=connection.getOIModelForRDFModel(model);
        m_oimodel.applyChanges(Collections.singletonList(new AddIncludedOIModel(connection.openOIModelLogical(KAONConnection.LEXICAL_OIMODEL_URI))));
        m_evolutionStrategy=new EvolutionStrategyImpl(m_oimodel);
    }
    protected void applyChanges(ChangeEvent[] events) throws Exception {
        List list=new LinkedList();
        for (int i=0;i<events.length;i++)
            list.add(events[i]);
        applyChanges(list);
    }
    protected void applyChanges(List list) throws Exception {
        List neededChanges=m_evolutionStrategy.computeRequestedChanges(list);
        m_oimodel.applyChanges(neededChanges);
    }
    protected void applyChange(ChangeEvent event) throws Exception {
        List list=new LinkedList();
        list.add(event);
        applyChanges(list);
    }
    protected static void addModel(Model target,Model source) throws Exception {
        Iterator iterator=source.iterator();
        NodeFactory nodeFactory=target.getNodeFactory();
        while (iterator.hasNext()) {
            Statement statement=(Statement)iterator.next();
            Resource subject=nodeFactory.createResource(statement.subject().getURI());
            Resource predicate=nodeFactory.createResource(statement.predicate().getURI());
            RDFNode object=statement.object();
            if (object instanceof Resource)
                object=nodeFactory.createResource(((Resource)object).getURI());
            else
                object=nodeFactory.createLiteral(object.getLabel());
            target.add(nodeFactory.createStatement(subject,predicate,object));
        }
    }
    protected void assertSetEquals(Set set,Object[] elements) {
        if (elements==null)
            assertTrue("Set should be empty",set.isEmpty());
        else {
            assertEquals("Set doesn't have the same size as the control value",elements.length,set.size());
            for (int i=0;i<elements.length;i++)
                if (!set.contains(elements[i]))
                    fail("Set doesn't contain element "+elements[i]);
        }
    }
    protected abstract Model getDefaultModel();
}
