package edu.unika.aifb.kaon.defaultevolution;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Evolution strategy that computes requested changes programatically.
 *
 * @author Ljiljana Stojanovic (Ljiljana.Stojanovic@fzi.de)
 */
public class EvolutionStrategyImpl extends EvolutionParameters implements EvolutionStrategy {
    /** The OI-model that this strategy maintains. */
    protected OIModel m_oimodel;

    /**
     * Creates an instance of this class.
     *
     * @param oimodel                   the OI-model
     */
    public EvolutionStrategyImpl(OIModel oimodel) {
        m_oimodel=oimodel;
    }
    /**
     * Computes the list of elementary changes from given list of requested changes.
     *
     * @param changeList                list of requested changes
     * @return                          list of needed changes
     * @exception KAONException         thrown if changes cannot be applied
     */
    public List computeRequestedChanges(List changeList) throws KAONException {
        // Important! This object must be kept in scope for the duration of evolution. Otherwise the loaded
        // objects may be garbage-collected before the appropriate events are dispatched.
        EvolutionLoadVisitor loadVisitor=null;
        if ((m_oimodel.getCapabilities() & OIModel.CAPABILITY_SUPPORTS_OPTIMIZED_LOADING)!=0) {
            loadVisitor=new EvolutionLoadVisitor(m_oimodel);
            loadVisitor.preloadObjects(changeList);
        }
        List generatedEvents=new LinkedList();
        ChangeVisitor changeVisitor=new EvolutionChangeVisitor(this,m_oimodel,null,generatedEvents);
        Iterator changes=changeList.iterator();
        while (changes.hasNext()) {
            ChangeEvent changeEvent=(ChangeEvent)changes.next();
            changeEvent.setOIModel(m_oimodel);
            changeEvent.accept(changeVisitor);
        }
        return generatedEvents;
    }
}
