package edu.unika.aifb.kaon.api.vocabulary;

/**
 * Vocabulary for current RDF things.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RDFVocabularyAdaptor extends VocabularyAdaptor {
    /** An instance of this class. */
    public static final RDFVocabularyAdaptor INSTANCE=new RDFVocabularyAdaptor();
    /** Namespace for the RDF. */
    protected static final String RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    /**
     * Creates an instance of this class.
     */
    protected RDFVocabularyAdaptor() {
    }
    /**
     * Returns the name of the 'Property' resource.
     */
    public String getProperty() {
        return RDF+"Property";
    }

    /**
    * Returns the name of the 'instanceOf' property.
    */
    public String getInstanceOf() {
        return RDF+"type";
    }

}