package edu.unika.aifb.kaon.api.vocabulary;

/**
 * Vocabulary for the current RDFS specification.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RDFSVocabularyAdaptor extends RDFVocabularyAdaptor {
    /** An instance of this class. */
    public static final RDFSVocabularyAdaptor INSTANCE=new RDFSVocabularyAdaptor();
    /** Namespace for the RDFS. */
    protected static final String RDFS="http://www.w3.org/2000/01/rdf-schema#";

    /**
     * Creates an instance of this class.
     */
	protected RDFSVocabularyAdaptor() {
	}
    /**
     * Returns the name of the 'Resource' resource.
     */
    public String getResource() {
        return RDFS+"Resource";
    }
    /**
     * Returns the name of the 'Literal' resource.
     */
    public String getLiteral() {
        return RDFS+"Literal";
    }
    /**
     * Returns the name of the 'ContraintResource' resource.
     */
    public String getConstraintResource() {
        return RDFS+"ConstraintResource";
    }
    /**
     * Returns the name of the 'ConstraintProperty' resource.
     */
    public String getContraintProperty() {
        return RDFS+"ConstraintProperty";
    }
    /**
     * Returns the name of the 'domain' property.
     */
    public String getDomain() {
        return RDFS+"domain";
    }
    /**
     * Returns the name of the 'range' property.
     */
    public String getRange() {
        return RDFS+"range";
    }
    /**
     * Returns the name of the 'label' property.
     */
    public String getLabel() {
        return RDFS+"label";
    }
    /**
     * Returns the name of the 'comment' property
     */
    public String getComment() {
        return RDFS+"comment";
    }
    /**
     * Returns the name of the 'subClassOf' property.
     */
    public String getSubClassOf() {
        return RDFS+"subClassOf";
    }
    /**
     * Returns the name of the 'subPropertyOf' property.
     */
    public String getSubPropertyOf() {
        return RDFS+"subPropertyOf";
    }
    /**
     * Returns the name of the 'Concept' resource.
     */
    public String getClass_() {
        return RDFS+"Class";
    }
}