package edu.unika.aifb.kaon.api.vocabulary;

/**
 * Vocabulary for the current KAON specification.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class KAONVocabularyAdaptor extends RDFSVocabularyAdaptor {
    /** An instance of this class. */
    public static final KAONVocabularyAdaptor INSTANCE=new KAONVocabularyAdaptor();
    /** Namespace for the KAON specification. */
    public static final String KAON="http://kaon.semanticweb.org/2001/11/kaon-lexical#";

    /**
     * Creates an instance of this class.
     */
	protected KAONVocabularyAdaptor() {
	}
    public String getKAONLabel() {
        return KAON+"Label";
    }
    public String getLanguageURI(String language) {
        return KAON+language;
    }
    public String getInLanguage() {
        return KAON+"inLanguage";
    }
    public String getLanguage() {
        return KAON+"Language";
    }
    public String getLexicalEntry() {
        return KAON+"LexicalEntry";
    }
    public String getRoot() {
        return KAON+"Root";
    }
    public String getStem() {
        return KAON+"Stem";
    }
    public String getDocumentation() {
        return KAON+"Documentation";
    }
    public String getSynonym() {
        return KAON+"Synonym";
    }
    public String getReferences() {
        return KAON+"references";
    }
    public String getValue() {
        return KAON+"value";
    }
    public String getInverse() {
        return KAON+"inverse";
    }
    public String getSymmetric() {
        return KAON+"symmetric";
    }
    public String getTransitive() {
        return KAON+"transitive";
    }
    public String getMinCardinality() {
        return KAON+"minCardinality";
    }
    public String getMaxCardinality() {
        return KAON+"maxCardinality";
    }
}
