package edu.unika.aifb.kaon.api.util;

import java.util.List;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Merges information about an update into the original event list.
 */
public class UpdateMerger extends NullChangeEventVisitor {
    /** Current updated event. */
    protected ChangeEvent m_updatedEvent;

    /**
     * Creates an instance of this class.
     */
    public UpdateMerger() {
    }
    /**
     * Processes the list of updated events and forwards the updates to the original events.
     *
     * @param originalEvent         the original event to process
     * @param updatedEvent          the updated event to process
     */
    public void processEvents(ChangeEvent originalEvent,ChangeEvent updatedEvent) throws KAONException {
        try {
            m_updatedEvent=updatedEvent;
            originalEvent.accept(this);
        }
        finally {
            m_updatedEvent=null;
        }
    }
    /**
     * Merges entire list.
     *
     * @param originalEvents        the list of original events
     * @param updatedEvents         the list of updated events
     */
    public void mergeEvents(List originalEvents,List updatedEvents) throws KAONException {
        Iterator original=originalEvents.iterator();
        Iterator updated=updatedEvents.iterator();
        while (original.hasNext()) {
            ChangeEvent originalEvent=(ChangeEvent)original.next();
            ChangeEvent updatedEvent=(ChangeEvent)updated.next();
            processEvents(originalEvent,updatedEvent);
        }
    }
    /**
     * Visits an event for determinig whether property is attirubte.
     */
    public void visit(SetPropertyIsAttribute event) {
        event.setOldIsAttirubte(((SetPropertyIsAttribute)m_updatedEvent).getOldIsAttribute());
    }
    /**
     * Visits an event for setting the minimum cardinality of a property for a concept.
     */
    public void visit(SetMinimumCardinality event) {
        event.setOldCardinality(((SetMinimumCardinality)m_updatedEvent).getOldCardinality());
    }
    /**
     * Visits an event for setting the maximum cardinality of a property for a concept.
     */
    public void visit(SetMaximumCardinality event) {
        event.setOldCardinality(((SetMaximumCardinality)m_updatedEvent).getOldCardinality());
    }
    /**
     * Visits an event for setting the symmetry flag of the property.
     */
    public void visit(SetPropertySymmetric event) {
        event.setOldSymmetric(event.getOldSymmetric());
    }
    /**
     * Visits an event for setting the transitivity flag of the property.
     */
    public void visit(SetPropertyTransitive event) {
        event.setOldTransitive(event.getOldTransitive());
    }
    /**
     * Visits an event for settomg the value of a property instance.
     */
    public void visit(SetPropertyInstanceValue event) throws KAONException {
        OIModel oimodel=event.getPropertyInstance().getOIModel();
        PropertyInstance[] updatedRemovedInstances=((SetPropertyInstanceValue)m_updatedEvent).getRemovedInstances();
        PropertyInstance[] removedInstances=new PropertyInstance[updatedRemovedInstances.length];
        for (int i=0;i<updatedRemovedInstances.length;i++) {
            Instance removedSourceInstance=oimodel.getInstance(updatedRemovedInstances[i].getSourceInstance().getURI());
            Property removedProperty=oimodel.getProperty(updatedRemovedInstances[i].getProperty().getURI());
            Object updatedTargetValue=updatedRemovedInstances[i].getTargetValue();
            Object removedTargetValue;
            if (updatedTargetValue instanceof Instance)
                removedTargetValue=oimodel.getInstance(((Instance)updatedTargetValue).getURI());
            else
                removedTargetValue=updatedTargetValue;
            removedInstances[i]=oimodel.getPropertyInstance(removedProperty,removedSourceInstance,removedTargetValue);
        }
        event.setRemovedInstances(removedInstances);
    }
}
