package edu.unika.aifb.kaon.api.util;

import java.util.Random;

/**
 * Using this class it is possible to generate URIs that are unique in time. For URI generation the user must
 * supply a valid URI prefix (e.g. http://something.com/document#). Based on the current time and random number
 * generator, this class will generate an URI that will habe a hight probability to be unique. The URIs are not
 * guarranteed to be unique in space, but this can be alleviated by using namespaces.
 */
public class UniqueURIGenerator {
    /** The random number generator. */
    protected static final Random s_random=new Random();

    /**
     * Generates an URI with reasonable degree of uniqueness.
     *
     * @param uriPrefix                 the prefix of the URI
     * @return                          unique URI
     */
    public static String getUniqueURI(String uriPrefix) {
        if (!uriPrefix.endsWith("#"))
            uriPrefix+="#";
        String newURI=uriPrefix+"i-"+System.currentTimeMillis()+"-"+Math.abs(s_random.nextInt());
        return newURI;
    }
}
