package edu.unika.aifb.kaon.api.util;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Collection;
import java.util.Collections;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * A utility class for managing property instances.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class PropertyInstanceUtil {
    /**
     * Returns <code>true</code> if the instance satisties given set of concepts.
     *
     * @param instance                      instance being tested
     * @param conceptSet                    the set of concepts against which the instance is checked
     * @return                              <code>true</code> if instance satisfies given set of concepts
     * @throws KAONException                thrown if thre is an error
     */
    public static boolean instanceSatisfiesConceptSet(Instance instance,Set conceptSet) throws KAONException {
        Set parentConcepts=instance.getParentConcepts();
        Iterator iterator=conceptSet.iterator();
        outer: while (iterator.hasNext()) {
            Concept concept=(Concept)iterator.next();
            if (!parentConcepts.contains(concept)) {
                Iterator parentConceptsIterator=parentConcepts.iterator();
                while (parentConceptsIterator.hasNext()) {
                    Concept parentConcept=(Concept)parentConceptsIterator.next();
                    if (parentConcept.isSubConceptOf(concept))
                        continue outer;
                }
                return false;
            }
        }
        return true;
    }
    /**
     * Computes the set of properties that can be applied to given instance.
     *
     * @param sourceInstance                instance to which properties are applied
     * @param selection                     the set of objects to which the properties should be applied
     * @return                              set of alloed properties
     * @throws KAONException                thrown if thre is an error
     */
    public static Set getAllowedProperties(Instance sourceInstance,Collection selection) throws KAONException {
        Iterator iterator=selection.iterator();
        while (iterator.hasNext()) {
            Object selectedObject=iterator.next();
            if (!(selectedObject instanceof Instance))
                return Collections.EMPTY_SET;
        }
        Set allowedProperties=new HashSet();
        Iterator parentConcepts=sourceInstance.getParentConcepts().iterator();
        while (parentConcepts.hasNext()) {
            Concept concept=(Concept)parentConcepts.next();
            allowedProperties.addAll(concept.getAllPropertiesFromConcept());
        }
        Iterator properties=allowedProperties.iterator();
        while (properties.hasNext()) {
            Property property=(Property)properties.next();
            if (property.isAttribute())
                properties.remove();
            else {
                if (!instanceSatisfiesConceptSet(sourceInstance,property.getDomainConcepts()))
                    properties.remove();
                else {
                    Set rangeConcepts=property.getRangeConcepts();
                    iterator=selection.iterator();
                    while (iterator.hasNext()) {
                        Instance targetInstance=(Instance)iterator.next();
                        if (!instanceSatisfiesConceptSet(targetInstance,rangeConcepts)) {
                            properties.remove();
                            break;
                        }
                    }
                }
            }
        }
        return allowedProperties;
    }
}
