package edu.unika.aifb.kaon.api.util;

import java.util.List;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

public class PrintVisitor implements ChangeVisitor {
    /**
     * Prints the list of events.
     *
     * @param list                      the list of events
     * @throws KAONException            thrown in case of error
     */
    public void printEvents(List list) throws KAONException {
        Iterator iterator=list.iterator();
        while (iterator.hasNext()) {
            ChangeEvent changeEvent=(ChangeEvent)iterator.next();
            changeEvent.accept(this);
        }
    }
    /**
     * Visits AddEntity change.
     */
    public void visit(AddEntity event) throws KAONException {
        System.out.println("AddEntity, URI="+event.getEntity().getURI());
    }
    /**
     * Visits RemoveEntity change.
     */
    public void visit(RemoveEntity event) throws KAONException {
        System.out.println("RemoveEntity, URI="+event.getEntity().getURI());
    }
    /**
     * Visits an event for creation of subconcepts.
     */
    public void visit(AddSubConcept event) throws KAONException {
        System.out.println("AddSubConcept, superConcept="+event.getSuperConcept().getURI()+", subConcept="+event.getSubConcept().getURI());
    }
    /**
     * Visits an event for removal of subconcepts.
     */
    public void visit(RemoveSubConcept event) throws KAONException {
        System.out.println("RemoveSubConcept, superConcept="+event.getSuperConcept().getURI()+", subConcept="+event.getSubConcept().getURI());
    }
    /**
     * Visits an event for adding a domain to the property.
     */
    public void visit(AddPropertyDomain event) throws KAONException {
        System.out.println("AddPropertyDomain, property="+event.getProperty().getURI()+", concept="+event.getConcept().getURI());
    }
    /**
     * Visits an event for removing a domain from the property.
     */
    public void visit(RemovePropertyDomain event) throws KAONException {
        System.out.println("RemovePropertyDomain, property="+event.getProperty().getURI()+", concept="+event.getConcept().getURI());
    }
    /**
     * Visits an event for adding a range to the property.
     */
    public void visit(AddPropertyRange event) throws KAONException {
        System.out.println("AddPropertyRange, property="+event.getProperty().getURI()+", concept="+event.getConcept().getURI());
    }
    /**
     * Visits an event for removing a range from the property.
     */
    public void visit(RemovePropertyRange event) throws KAONException {
        System.out.println("RemovePropertyRange, property="+event.getProperty().getURI()+", concept="+event.getConcept().getURI());
    }
    /**
     * Visits an event for determinig whether property is attirubte.
     */
    public void visit(SetPropertyIsAttribute event) throws KAONException {
        System.out.println("SetPropertyIsAttribute, property="+event.getProperty().getURI()+", isAttribute="+event.getIsAttribute());
    }
    /**
     * Visits an event for setting the minimum cardinality of a property for a concept.
     */
    public void visit(SetMinimumCardinality event) throws KAONException {
        System.out.println("SetMinimumCardinality, property="+event.getProperty().getURI()+", concept="+event.getConcept().getURI()+", cardinality="+event.getCardinality());
    }
    /**
     * Visits an event for setting the maximum cardinality of a property for a concept.
     */
    public void visit(SetMaximumCardinality event) throws KAONException {
        System.out.println("SetMaximumCardinality, property="+event.getProperty().getURI()+", concept="+event.getConcept().getURI()+", cardinality="+event.getCardinality());
    }
    /**
     * Visits an event for creation of subproperties.
     */
    public void visit(AddSubProperty event) throws KAONException {
        System.out.println("AddSubProperty, superProperty="+event.getSuperProperty().getURI()+", subProperty="+event.getSubProperty().getURI());
    }
    /**
     * Visits an event for removal of subproperties.
     */
    public void visit(RemoveSubProperty event) throws KAONException {
        System.out.println("RemoveSubProperty, superProperty="+event.getSuperProperty().getURI()+", subProperty="+event.getSubProperty().getURI());
    }
    /**
     * Visits an event for setting the inverse relationship between properties.
     */
    public void visit(SetInverseProperties event) throws KAONException {
        System.out.println("SetInverseProperties, property1="+event.getProperty1().getURI()+", property2="+event.getProperty2().getURI());
    }
    /**
     * Visits an event for removing an inverse relationship between properties.
     */
    public void visit(SetNoInverseProperties event) throws KAONException {
        System.out.println("SetNoInverseProperties, property1="+event.getProperty1().getURI()+", property2="+event.getProperty2().getURI());
    }
    /**
     * Visits an event for setting the symmetry flag of the property.
     */
    public void visit(SetPropertySymmetric event) throws KAONException {
        System.out.println("SetPropertySymmetric, property="+event.getProperty().getURI()+", symmetric="+event.getSymmetric());
    }
    /**
     * Visits an event for setting the transitivity flag of the property.
     */
    public void visit(SetPropertyTransitive event) throws KAONException {
        System.out.println("SetPropertyTransitive, property="+event.getProperty().getURI()+", transitive="+event.getTransitive());
    }
    /**
     * Visits an event for making an instance a subinstance of given concept.
     */
    public void visit(AddInstanceOf event) throws KAONException {
        System.out.println("AddInstanceOf, concept="+event.getConcept().getURI()+", instance="+event.getInstance().getURI());
    }
    /**
     * Visits an event for making an instance not a subinstance of given concept.
     */
    public void visit(RemoveInstanceOf event) throws KAONException {
        System.out.println("RemoveInstanceOf, concept="+event.getConcept().getURI()+", instance="+event.getInstance().getURI());
    }
    /**
     * Visits an event for adding a property instance.
     */
    public void visit(AddPropertyInstance event) throws KAONException {
        PropertyInstance propertyInstance=event.getPropertyInstance();
        if (propertyInstance.getTargetValue() instanceof Instance)
            System.out.println("AddPropertyInstance, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", target="+((Instance)propertyInstance.getTargetValue()).getURI());
        else
            System.out.println("AddPropertyInstance, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", value="+propertyInstance.getTargetValue());
    }
    /**
     * Visits an event for removing a property instance.
     */
    public void visit(RemovePropertyInstance event) throws KAONException {
        PropertyInstance propertyInstance=event.getPropertyInstance();
        if (propertyInstance.getTargetValue() instanceof Instance)
            System.out.println("RemovePropertyInstance, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", target="+((Instance)propertyInstance.getTargetValue()).getURI());
        else
            System.out.println("RemovePropertyInstance, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", value="+propertyInstance.getTargetValue());
    }
    /**
     * Visits an event for setting the value of a property instance.
     */
    public void visit(SetPropertyInstanceValue event) throws KAONException {
        PropertyInstance propertyInstance=event.getPropertyInstance();
        if (propertyInstance.getTargetValue() instanceof Instance)
            System.out.println("SetPropertyInstanceValue, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", target="+((Instance)propertyInstance.getTargetValue()).getURI());
        else
            System.out.println("SetPropertyInstanceValue, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", value="+propertyInstance.getTargetValue());
    }
    /**
     * Visits an event for changing the value of a property instance.
     */
    public void visit(ChangePropertyInstanceValue event) throws KAONException {
        PropertyInstance propertyInstance=event.getPropertyInstance();
        String newTargetValue;
        if (event.getNewTargetValue() instanceof Instance)
            newTargetValue=((Instance)event.getNewTargetValue()).getURI();
        else
            newTargetValue=event.getNewTargetValue().toString();
        if (propertyInstance.getTargetValue() instanceof Instance)
            System.out.println("ChangePropertyInstanceValue, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", target="+((Instance)propertyInstance.getTargetValue()).getURI()+", newTargetValue="+newTargetValue);
        else
            System.out.println("ChangePropertyInstanceValue, property="+propertyInstance.getProperty().getURI()+", source="+propertyInstance.getSourceInstance().getURI()+", value="+propertyInstance.getTargetValue()+", newTargetValue="+newTargetValue);
    }
    /**
     * Visits an event for making a model included in another model.
     */
    public void visit(AddIncludedOIModel event) throws KAONException {
        System.out.println("AddIncludedOIModel, model="+event.getIncludedOIModel().getLogicalURI());
    }
    /**
     * Visits an event for making a model not included in another model.
     */
    public void visit(RemoveIncludedOIModel event) throws KAONException {
        System.out.println("RemoveIncludedOIModel, model="+event.getIncludedOIModel().getLogicalURI());
    }
}
