package edu.unika.aifb.kaon.api.util;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Contains utility functions for OI-models.
 */
public class OIModels {

    private OIModels() {
    }
    /**
     * Sorts given OI-models into a list so that including OI-models are after included OI-models.
     *
     * @param oimodels                          the set of OI-models
     * @return                                  the list of sorted OI-models
     * @throws KAONException                    thrown if there is a problem
     */
    public static List topologicallySortOIModels(Set oimodels) throws KAONException {
        List result=new LinkedList();
        Set markSet=new HashSet(oimodels);
        int lastSize=-1;
        while (!markSet.isEmpty()) {
            OIModel oimodel=(OIModel)markSet.iterator().next();
            processPredecendents(oimodel,markSet,result);
            if (lastSize==result.size())
                throw new KAONException("OI-models have a cycle");
            lastSize=result.size();
        }
        return result;
    }
    private static void processPredecendents(OIModel oimodel,Set markSet,List result) throws KAONException  {
        markSet.remove(oimodel);
        Iterator iterator=oimodel.getIncludedOIModels().iterator();
        while (iterator.hasNext()) {
            OIModel includedOIModel=(OIModel)iterator.next();
            if (markSet.contains(includedOIModel))
                processPredecendents(includedOIModel,markSet,result);
        }
        result.add(oimodel);
    }
    /**
     * Finds all included oimodels.
     *
     * @param oimodel                   the oimodel
     * @return                          all included oimodels
     */
    public static Set getAllIncludedOIModels(OIModel oimodel) throws KAONException {
        Set set=oimodel.getIncludedOIModels();
        Set result=new HashSet(set);
        Iterator iterator=set.iterator();
        while (iterator.hasNext()) {
            OIModel currentOIModel=(OIModel)iterator.next();
            result.addAll(getAllIncludedOIModels(currentOIModel));
        }
        return result;
    }
}