package edu.unika.aifb.kaon.api.util;

import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

/**
 * Visitor that transforms events from the included models to this model.
 */
public abstract class ChangeEventCopier implements ChangeVisitor {
    protected OIModel m_oimodel;
    protected ChangeEvent m_sourceEvent;
    protected Map m_events;
    protected EntityVisitor m_addEntityEventForwardingVisitor=new AddEntityEventForwardingVisitor();
    protected EntityVisitor m_removeEntityEventForwardingVisitor=new RemoveEntityEventForwardingVisitor();

    public ChangeEventCopier() {
        this(null);
    }
    public ChangeEventCopier(OIModel oimodel) {
        m_oimodel=oimodel;
        m_events=new HashMap();
    }
    public void clear() {
        m_events.clear();
        m_sourceEvent=null;
    }
    public void fixCauses() {
        Iterator sourceEvents=m_events.keySet().iterator();
        while (sourceEvents.hasNext()) {
            ChangeEvent sourceChangeEvent=(ChangeEvent)sourceEvents.next();
            ChangeEvent copiedChangeEvent=(ChangeEvent)m_events.get(sourceChangeEvent);
            ChangeEvent sourceCause=sourceChangeEvent.getCause();
            if (sourceCause!=null) {
                ChangeEvent targetCause=(ChangeEvent)m_events.get(sourceCause);
                copiedChangeEvent.setCause(targetCause);
            }
        }
    }
    public void processChanges(List changeEvents) throws KAONException {
        try {
            Iterator iterator=changeEvents.iterator();
            while (iterator.hasNext()) {
                ChangeEvent event=(ChangeEvent)iterator.next();
                event.accept(this);
            }
            fixCauses();
        }
        finally {
            clear();
        }
    }
    protected abstract void consumeEvent(ChangeEvent changeEvent) throws KAONException;
    protected void consumeEventInternal(ChangeEvent copiedChangeEvent) throws KAONException {
        copiedChangeEvent.setOIModel(getOIModel(m_sourceEvent.getOIModel()));
        m_events.put(m_sourceEvent,copiedChangeEvent);
        consumeEvent(copiedChangeEvent);
    }
    protected Concept getConcept(Concept concept) throws KAONException {
        return m_oimodel.getConcept(concept.getURI());
    }
    protected Property getProperty(Property property) throws KAONException {
        return m_oimodel.getProperty(property.getURI());
    }
    protected Instance getInstance(Instance instance) throws KAONException {
        return m_oimodel.getInstance(instance.getURI());
    }
    protected OIModel getOIModel(OIModel oimodel) throws KAONException {
        return m_oimodel.getKAONConnection().openOIModelLogical(oimodel.getLogicalURI());
    }
    protected LexicalEntry getLexicalEntry(LexicalEntry lexicalEntry) throws KAONException {
        return m_oimodel.getLexicalEntry(lexicalEntry.getURI());
    }
    protected PropertyInstance getPropertyInstance(PropertyInstance propertyInstance) throws KAONException {
        Object targetValue=propertyInstance.getTargetValue();
        Object newTargetValue;
        if (targetValue instanceof Instance)
            newTargetValue=getInstance((Instance)targetValue);
        else
            newTargetValue=targetValue;
        return m_oimodel.getPropertyInstance(getProperty(propertyInstance.getProperty()),getInstance(propertyInstance.getSourceInstance()),newTargetValue);
    }
    protected boolean preprocessEvent(ChangeEvent event) throws KAONException {
        m_sourceEvent=event;
        return true;
    }
    public void visit(AddEntity event) throws KAONException {
        if (preprocessEvent(event))
            event.getEntity().accept(m_addEntityEventForwardingVisitor);
    }
    public void visit(RemoveEntity event) throws KAONException {
        if (preprocessEvent(event))
            event.getEntity().accept(m_removeEntityEventForwardingVisitor);
    }
    public void visit(AddSubConcept event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new AddSubConcept(getConcept(event.getSuperConcept()),getConcept(event.getSubConcept())));
    }
    public void visit(RemoveSubConcept event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new RemoveSubConcept(getConcept(event.getSuperConcept()),getConcept(event.getSubConcept())));
    }
    public void visit(AddPropertyDomain event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new AddPropertyDomain(getProperty(event.getProperty()),getConcept(event.getConcept())));
    }
    public void visit(RemovePropertyDomain event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new RemovePropertyDomain(getProperty(event.getProperty()),getConcept(event.getConcept())));
    }
    public void visit(AddPropertyRange event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new AddPropertyRange(getProperty(event.getProperty()),getConcept(event.getConcept())));
    }
    public void visit(RemovePropertyRange event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new RemovePropertyRange(getProperty(event.getProperty()),getConcept(event.getConcept())));
    }
    public void visit(SetPropertyIsAttribute event) throws KAONException {
        if (preprocessEvent(event)) {
            SetPropertyIsAttribute newEvent=new SetPropertyIsAttribute(getProperty(event.getProperty()),event.getIsAttribute());
            newEvent.setOldIsAttirubte(event.getOldIsAttribute());
            consumeEventInternal(newEvent);
        }
    }
    public void visit(SetMinimumCardinality event) throws KAONException {
        if (preprocessEvent(event)) {
            SetMinimumCardinality newEvent=new SetMinimumCardinality(getProperty(event.getProperty()),getConcept(event.getConcept()),event.getCardinality());
            newEvent.setOldCardinality(event.getOldCardinality());
            consumeEventInternal(newEvent);
        }
    }
    public void visit(SetMaximumCardinality event) throws KAONException {
        if (preprocessEvent(event)) {
            SetMaximumCardinality newEvent=new SetMaximumCardinality(getProperty(event.getProperty()),getConcept(event.getConcept()),event.getCardinality());
            newEvent.setOldCardinality(event.getOldCardinality());
            consumeEventInternal(newEvent);
        }
    }
    public void visit(AddSubProperty event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new AddSubProperty(getProperty(event.getSuperProperty()),getProperty(event.getSubProperty())));
    }
    public void visit(RemoveSubProperty event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new RemoveSubProperty(getProperty(event.getSuperProperty()),getProperty(event.getSubProperty())));
    }
    public void visit(SetInverseProperties event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new SetInverseProperties(getProperty(event.getProperty1()),getProperty(event.getProperty2())));
    }
    public void visit(SetNoInverseProperties event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new SetNoInverseProperties(getProperty(event.getProperty1()),getProperty(event.getProperty2())));
    }
    public void visit(SetPropertySymmetric event) throws KAONException {
        if (preprocessEvent(event)) {
            SetPropertySymmetric newEvent=new SetPropertySymmetric(getProperty(event.getProperty()),event.getSymmetric());
            newEvent.setOldSymmetric(event.getOldSymmetric());
            consumeEventInternal(newEvent);
        }
    }
    public void visit(SetPropertyTransitive event) throws KAONException {
        if (preprocessEvent(event)) {
            SetPropertyTransitive newEvent=new SetPropertyTransitive(getProperty(event.getProperty()),event.getTransitive());
            newEvent.setOldTransitive(event.getOldTransitive());
            consumeEventInternal(newEvent);
        }
    }
    public void visit(AddInstanceOf event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new AddInstanceOf(getConcept(event.getConcept()),getInstance(event.getInstance())));
    }
    public void visit(RemoveInstanceOf event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new RemoveInstanceOf(getConcept(event.getConcept()),getInstance(event.getInstance())));
    }
    public void visit(AddPropertyInstance event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new AddPropertyInstance(getPropertyInstance(event.getPropertyInstance())));
    }
    public void visit(RemovePropertyInstance event) throws KAONException {
        if (preprocessEvent(event))
            consumeEventInternal(new RemovePropertyInstance(getPropertyInstance(event.getPropertyInstance())));
    }
    public void visit(SetPropertyInstanceValue event) throws KAONException {
        if (preprocessEvent(event)) {
            SetPropertyInstanceValue newEvent=new SetPropertyInstanceValue(getPropertyInstance(event.getPropertyInstance()));
            PropertyInstance[] removedPropertyInstances=event.getRemovedInstances();
            if (removedPropertyInstances!=null) {
                PropertyInstance[] newRemovedPropertyInstances=new PropertyInstance[removedPropertyInstances.length];
                for (int i=0;i<removedPropertyInstances.length;i++)
                    newRemovedPropertyInstances[i]=getPropertyInstance(removedPropertyInstances[i]);
                newEvent.setRemovedInstances(newRemovedPropertyInstances);
            }
            consumeEventInternal(newEvent);
        }
    }
    public void visit(ChangePropertyInstanceValue event) throws KAONException {
        if (preprocessEvent(event)) {
            Object newTargetValue;
            if (event.getNewTargetValue() instanceof Instance)
                newTargetValue=getInstance((Instance)event.getNewTargetValue());
            else
                newTargetValue=event.getNewTargetValue();
            consumeEventInternal(new ChangePropertyInstanceValue(getPropertyInstance(event.getPropertyInstance()),newTargetValue));
        }
    }
    public void visit(AddIncludedOIModel event) throws KAONException {
        if (preprocessEvent(event)) {
            AddIncludedOIModel copiedChangeEvent=new AddIncludedOIModel(getOIModel(event.getOIModel()),null,getOIModel(event.getIncludedOIModel()));
            m_events.put(m_sourceEvent,copiedChangeEvent);
            consumeEvent(copiedChangeEvent);
        }
    }
    public void visit(RemoveIncludedOIModel event) throws KAONException {
        if (preprocessEvent(event)) {
            RemoveIncludedOIModel copiedChangeEvent=new RemoveIncludedOIModel(getOIModel(event.getOIModel()),null,getOIModel(event.getIncludedOIModel()));
            m_events.put(m_sourceEvent,copiedChangeEvent);
            consumeEvent(copiedChangeEvent);
        }
    }

    /**
     * Visitor that forwars events for adding.
     */
    protected class AddEntityEventForwardingVisitor implements EntityVisitor {
        public void visit(Concept entity) throws KAONException {
            consumeEventInternal(new AddEntity(getConcept(entity)));
        }
        public void visit(Property entity) throws KAONException {
            consumeEventInternal(new AddEntity(getProperty(entity)));
        }
        public void visit(Instance entity) throws KAONException {
            consumeEventInternal(new AddEntity(getInstance(entity)));
        }
        public void visit(LexicalEntry entity) throws KAONException {
            consumeEventInternal(new AddEntity(getLexicalEntry(entity)));
        }
    }

    /**
     * Visitor that forwars events for adding.
     */
    protected class RemoveEntityEventForwardingVisitor implements EntityVisitor {
        public void visit(Concept entity) throws KAONException {
            consumeEventInternal(new RemoveEntity(getConcept(entity)));
        }
        public void visit(Property entity) throws KAONException {
            consumeEventInternal(new RemoveEntity(getProperty(entity)));
        }
        public void visit(Instance entity) throws KAONException {
            consumeEventInternal(new RemoveEntity(getInstance(entity)));
        }
        public void visit(LexicalEntry entity) throws KAONException {
            consumeEventInternal(new RemoveEntity(getLexicalEntry(entity)));
        }
    }
}
