package edu.unika.aifb.kaon.api.oimodel;

import edu.unika.aifb.kaon.api.*;

/**
 * Models information about an instance of a <code>Property</code> object.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface PropertyInstance {
    /**
     * Returns the property.
     *
     * @return                                  property
     */
    Property getProperty() throws KAONException;
    /**
     * Returns the instance that this property instance points from.
     *
     * @return                                  source instance
     */
    Instance getSourceInstance() throws KAONException;
    /**
     * Returns the value of this property instnace (may be <code>String</code> or <code>Instance</code>).
     *
     * @return                                  value of this property instance (<code>String</code> or <code>Instnace</code>)
     */
    Object getTargetValue() throws KAONException;
    /**
     * Returns the OI-model of this object.
     *
     * @return                                  the OI-model of this object
     */
    OIModel getOIModel() throws KAONException;
    /**
     * Checks whether this property instance is in the OI-model.
     *
     * @return                                  <code>true</code> if this property instance is in the OI-model.
     */
    boolean isInOIModel() throws KAONException;
    /**
     * Returns <code>true</code> if this entity has been declared in the OI-model as returned
     * by <code>getOIModel()</code> call.
     *
     * @return                          <code>true</code> if this entity case declared in the OI-model as returned by <code>getOIModel()</code> call
     */
    boolean isDeclaredLocally() throws KAONException;
    /**
     * Returns the source OI-model of this object.
     *
     * @return                                  the source OI-model of this object
     */
    OIModel getSourceOIModel() throws KAONException;
}
