package edu.unika.aifb.kaon.api.oimodel;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;

/**
 * Represents an ontology.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface Ontology {
    /**
     * Returns a concept with given URI.
     *
     * @param uri                       URI of the requested concept
     * @return                          concept with given URI
     */
    Concept getConcept(String uri) throws KAONException;
    /**
     * Returns the root concepts of the ontology. Root concepts are concepts that are not subclasses of any other concept.
     *
     * @return                          set of root concepts (may be empty)
     */
    Concept getRootConcept() throws KAONException;
    /**
     * Returns all concepts of this ontology.
     *
     * @return                          set of all concepts in this ontology
     */
    Set getConcepts() throws KAONException;
    /**
     * Returns a property with given URI.
     *
     * @param uri                       URI of the property
     * @return                          property with given URI
     */
    Property getProperty(String uri) throws KAONException;
    /**
     * Returns all properties of this ontology.
     *
     * @return                          set of all properties of this ontology (may be empty)
     */
    Set getProperties() throws KAONException;
}
