package edu.unika.aifb.kaon.api.oimodel;

import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.Collection;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;

/**
 * Represents a pool of instances. Clients of this class can attach listeners to the pool in order to notified of events.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface OIModel extends Ontology,InstancePool {
    /** Load basic data of a concept. */
    final int LOAD_CONCEPT_BASICS=0x00000001;
    /** Load superconcepts. */
    final int LOAD_SUPER_CONCEPTS=0x00000002;
    /** Load subconcepts. */
    final int LOAD_SUB_CONCEPTS=0x00000004;
    /** Load properties from the concept. */
    final int LOAD_PROPERTIES_FROM=0x00000008;
    /** Load properties to the concept. */
    final int LOAD_PROPERTIES_TO=0x00000010;
    /** Load concept instances. */
    final int LOAD_CONCEPT_INSTANCES=0x00000020;
    /** Load all concept properties. */
    final int LOAD_CONCEPT_ALL=LOAD_CONCEPT_BASICS | LOAD_SUPER_CONCEPTS | LOAD_SUB_CONCEPTS | LOAD_PROPERTIES_FROM | LOAD_PROPERTIES_TO | LOAD_CONCEPT_INSTANCES;

    /** Load basic data of a property. */
    final int LOAD_PROPERTY_BASICS=0x00000040;
    /** Load superproperties. */
    final int LOAD_SUPER_PROPERTIES=0x00000080;
    /** Load subproperties. */
    final int LOAD_SUB_PROPERTIES=0x00000100;
    /** Load property domains. */
    final int LOAD_PROPERTY_DOMAINS=0x00000200;
    /** Load property ranges. */
    final int LOAD_PROPERTY_RANGES=0x00000400;
    /** Load property instances. */
    final int LOAD_PROPERTY_INSTANCES=0x00000800;
    /** Load all property information. */
    final int LOAD_PROPERTY_ALL=LOAD_PROPERTY_BASICS | LOAD_SUPER_PROPERTIES | LOAD_SUB_PROPERTIES | LOAD_PROPERTY_DOMAINS | LOAD_PROPERTY_RANGES | LOAD_PROPERTY_INSTANCES;

    /** Load basic data of an instance. */
    final int LOAD_INSTANCE_BASICS=0x00001000;
    /** Load instance parent concepts. */
    final int LOAD_INSTANCE_PARENT_CONCEPTS=0x00002000;
    /** Load property values from instance. */
    final int LOAD_INSTANCE_FROM_PROPERTY_VALUES=0x00004000;
    /** Load property values to instance. */
    final int LOAD_INSTANCE_TO_PROPERTY_VALUES=0x00008000;
    /** Load all instance information. */
    final int LOAD_INSTANCE_ALL=LOAD_INSTANCE_BASICS | LOAD_INSTANCE_PARENT_CONCEPTS | LOAD_INSTANCE_FROM_PROPERTY_VALUES | LOAD_INSTANCE_TO_PROPERTY_VALUES;

    /** Load the lexicon of an entity. */
    final int LOAD_LEXICON=0x00010000;

    /** Load all entity information. */
    final int LOAD_ENTITY_ALL=LOAD_CONCEPT_ALL | LOAD_PROPERTY_ALL | LOAD_INSTANCE_ALL | LOAD_LEXICON;

    /** Capability specifying that model is always saved. */
    final int CAPABILITY_ALWAYS_SAVED=0x00000001;
    /** Capability specifying that model supports optimized loading. */
    final int CAPABILITY_SUPPORTS_OPTIMIZED_LOADING=0x00000002;
    /** Capability specifying that model supports notifications. */
    final int CAPABILITY_SUPPORTS_NOTIFICATIONS=0x00000004;

    /**
     * Returns the capabilities of the model.
     *
     * @return                          the bit-mask defining the model's capaibilities
     */
    int getCapabilities() throws KAONException;
    /**
     * Returns the KAON connection of this OI-model.
     *
     * @return                          KAON connection of this OI-model
     */
    KAONConnection getKAONConnection() throws KAONException;
    /**
     * Returns the logical URI of this OI-model.
     *
     * @return                          logical URI of this OI-model
     */
    String getLogicalURI() throws KAONException;
    /**
     * Returns the physical URI of this OI-model.
     *
     * @return                          physical URI of this OI-model
     */
    String getPhysicalURI() throws KAONException;
    /**
     * Returns the set of included OI-models.
     *
     * @return                          set of included OI-models
     */
    Set getIncludedOIModels() throws KAONException;
    /**
     * Returns the set of models that include this model.
     *
     * @return                          set of OI-models that include this model
     */
    Set getAllIncludedByOIModels() throws KAONException;
    /**
     * Returns an included OI-model with given URI.
     *
     * @param logicalURI                logical URI of the requested OI-model
     * @return                          OI-model with given logical URI or <code>null</code> if OI-model with this logical URI wasn't included
     */
    OIModel getIncludedOIModel(String logicalURI) throws KAONException;
    /**
     * Adds a listener to this OI-model.
     *
     * @param listener                  listener to be added
     */
    void addOIModelListener(OIModelListener listener);
    /**
     * Removes a listener from this OI-model.
     *
     * @param listener                  listener to be removed
     */
    void removeOIModelListener(OIModelListener listener);
    /**
     * Suspends entity pool events until {@link #resumeEvents} is called.
     */
    void suspendEvents();
    /**
     * Resumes entity pool events.
     */
    void resumeEvents();
    /**
     * Processes changes in the change list.
     *
     * @param changeList                list of changes to the model
     */
    void applyChanges(List changeList) throws KAONException;
    /**
     * Makes sure that the objects in the collection are available for local processing.
     * This method is a performance optimization. Applications that don't call it will
     * still get correct data, but may not execute as quickly.
     *
     * @param objects                   objects to be loaded
     * @param loadFlag                  the flag of what to load
     */
    void loadObjects(Collection objects,int loadFlag) throws KAONException;
    /**
     * Executes a query and returns the set of instances or pairs matching given query.
     *
     * @param queryString               the query to be executed
     * @return                          the collection of result objects
     */
    Collection executeQuery(String queryString) throws KAONException;
    /**
     * Creates a new URI unique wihtin this OI-model.
     *
     * @return                          an new URI unique within this OI-model
     */
    String createNewURI() throws KAONException;
    /**
     * Creates an URI by combining the logical URI with the given suffix.
     *
     * @param suffix                    the suffix
     * @return                          a new URI with given suffix (may not be unique)
     */
    String getURI(String suffix) throws KAONException;
    /**
     * Makes sure that all data of this ontology is saved.
     */
    void save() throws KAONException;
    /**
     * Returns <code>true</code> if the OI-model has been changed since the last save.
     *
     * @return                          <code>true</code> if the OI-model has been changed since the last save
     */
    boolean hasUnsavedChanges() throws KAONException;
    /**
     * Deletes this OI-model.
     */
    void delete() throws KAONException;
    /**
     * Refreshes the contents of this OI-model.
     */
    void refresh() throws KAONException;
    /**
     * Returns the value of the OI-model attribute with given key.
     *
     * @param key                       the key
     * @return                          the value (or <code>null</code> if there is no attribute with given key)
     */
    String getAttribute(String key) throws KAONException;
    /**
     * Sets the value of the OI-model attribute with given key.
     *
     * @param key                       the key
     * @param value                     the value (or <code>null</code> if the attribute should be deleted)
     */
    void setAttribute(String key,String value) throws KAONException;
    /**
     * Returns the map of all key-value pairs of this OI-model.
     *
     * @return                          the map of key-value keys
     */
    Map getAttributes() throws KAONException;
}
